# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .imaging_study_status import ImagingStudyStatus
from .date_time import DateTime
from .unsigned_int import UnsignedInt
from .imaging_study_series import ImagingStudySeries
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ImagingStudy(BaseResource):
    """
    Representation of the content produced in a DICOM imaging study. A study comprises a set of series, each of which includes a set of Service-Object Pair Instances (SOP Instances - images or other data) acquired or produced in a common context. A series is of only one modality (e.g. X-ray, CT, MR, ultrasound), but a study may have multiple series of different modalities.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["ImagingStudy"], FieldMetadata(alias="resourceType")
    ] = "ImagingStudy"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Identifiers for the ImagingStudy such as DICOM Study Instance UID, and Accession Number.
    """

    status: typing.Optional[ImagingStudyStatus] = pydantic.Field(default=None)
    """
    The current state of the ImagingStudy.
    """

    modality: typing.Optional[typing.List[Coding]] = pydantic.Field(default=None)
    """
    A list of all the series.modality values that are actual acquisition modalities, i.e. those in the DICOM Context Group 29 (value set OID 1.2.840.10008.6.1.19).
    """

    subject: Reference = pydantic.Field()
    """
    The subject, typically a patient, of the imaging study.
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The healthcare event (e.g. a patient and healthcare provider interaction) during which this ImagingStudy is made.
    """

    started: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    Date and time the study started.
    """

    based_on: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="basedOn")
    ] = pydantic.Field(default=None)
    """
    A list of the diagnostic requests that resulted in this imaging study being performed.
    """

    referrer: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The requesting/referring physician.
    """

    interpreter: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Who read the study and interpreted the images or other content.
    """

    endpoint: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The network service providing access (e.g., query, view, or retrieval) for the study. See implementation notes for information about using DICOM endpoints. A study-level endpoint applies to each series in the study, unless overridden by a series-level endpoint with the same Endpoint.connectionType.
    """

    number_of_series: typing_extensions.Annotated[
        typing.Optional[UnsignedInt], FieldMetadata(alias="numberOfSeries")
    ] = pydantic.Field(default=None)
    """
    Number of Series in the Study. This value given may be larger than the number of series elements this Resource contains due to resource availability, security, or other factors. This element should be present if any series elements are present.
    """

    number_of_instances: typing_extensions.Annotated[
        typing.Optional[UnsignedInt], FieldMetadata(alias="numberOfInstances")
    ] = pydantic.Field(default=None)
    """
    Number of SOP Instances in Study. This value given may be larger than the number of instance elements this resource contains due to resource availability, security, or other factors. This element should be present if any instance elements are present.
    """

    procedure_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="procedureReference")
    ] = pydantic.Field(default=None)
    """
    The procedure which this ImagingStudy was part of.
    """

    procedure_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="procedureCode"),
    ] = pydantic.Field(default=None)
    """
    The code for the performed procedure type.
    """

    location: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The principal physical location where the ImagingStudy was performed.
    """

    reason_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="reasonCode")
    ] = pydantic.Field(default=None)
    """
    Description of clinical condition indicating why the ImagingStudy was requested.
    """

    reason_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="reasonReference")
    ] = pydantic.Field(default=None)
    """
    Indicates another resource whose existence justifies this Study.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Per the recommended DICOM mapping, this element is derived from the Study Description attribute (0008,1030). Observations or findings about the imaging study should be recorded in another resource, e.g. Observation, and not in this element.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Imaging Manager description of the study. Institution-generated description or classification of the Study (component) performed.
    """

    series: typing.Optional[typing.List[ImagingStudySeries]] = pydantic.Field(
        default=None
    )
    """
    Each study has one or more series of images or other content.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
