# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
import typing_extensions
from ...core.serialization import FieldMetadata
import pydantic
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class IdentityProvider(UniversalBaseModel):
    """
    External Identity Provider (IdP) configuration details.
    """

    authorize_url: typing_extensions.Annotated[
        str, FieldMetadata(alias="authorizeUrl")
    ] = pydantic.Field()
    """
    Remote URL for the external Identity Provider authorize endpoint.
    """

    token_url: typing_extensions.Annotated[str, FieldMetadata(alias="tokenUrl")] = (
        pydantic.Field()
    )
    """
    Remote URL for the external Identity Provider token endpoint.
    """

    user_info_url: typing_extensions.Annotated[
        str, FieldMetadata(alias="userInfoUrl")
    ] = pydantic.Field()
    """
    Remote URL for the external Identity Provider userinfo endpoint.
    """

    client_id: typing_extensions.Annotated[str, FieldMetadata(alias="clientId")] = (
        pydantic.Field()
    )
    """
    External Identity Provider client ID.
    """

    client_secret: typing_extensions.Annotated[
        str, FieldMetadata(alias="clientSecret")
    ] = pydantic.Field()
    """
    External Identity Provider client secret.
    """

    use_subject: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="useSubject")
    ] = pydantic.Field(default=None)
    """
    Optional flag to use the subject field instead of the email field.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
