# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .markdown import Markdown
from .healthcare_service_eligibility import HealthcareServiceEligibility
from .healthcare_service_available_time import HealthcareServiceAvailableTime
from .healthcare_service_not_available import HealthcareServiceNotAvailable
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class HealthcareService(BaseResource):
    """
    The details of a healthcare service available at a location.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["HealthcareService"], FieldMetadata(alias="resourceType")
    ] = "HealthcareService"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    External identifiers for this item.
    """

    active: typing.Optional[bool] = pydantic.Field(default=None)
    """
    This flag is used to mark the record to not be used. This is not used when a center is closed for maintenance, or for holidays, the notAvailable period is to be used for this.
    """

    provided_by: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="providedBy")
    ] = pydantic.Field(default=None)
    """
    The organization that provides this healthcare service.
    """

    category: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    Identifies the broad category of service being performed or delivered.
    """

    type: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    The specific type of service that may be delivered or performed.
    """

    specialty: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    Collection of specialties handled by the service site. This is more of a medical term.
    """

    location: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The location(s) where this healthcare service may be provided.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Further description of the service as it would be presented to a consumer while searching.
    """

    comment: typing.Optional[str] = pydantic.Field(default=None)
    """
    Any additional description of the service and/or any specific issues not covered by the other attributes, which can be displayed as further detail under the serviceName.
    """

    extra_details: typing_extensions.Annotated[
        typing.Optional[Markdown], FieldMetadata(alias="extraDetails")
    ] = pydantic.Field(default=None)
    """
    Extra details about the service that can't be placed in the other fields.
    """

    photo: typing.Optional[Attachment] = pydantic.Field(default=None)
    """
    If there is a photo/symbol associated with this HealthcareService, it may be included here to facilitate quick identification of the service in a list.
    """

    telecom: typing.Optional[typing.List[ContactPoint]] = pydantic.Field(default=None)
    """
    List of contacts related to this specific healthcare service.
    """

    coverage_area: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="coverageArea")
    ] = pydantic.Field(default=None)
    """
    The location(s) that this service is available to (not where the service is provided).
    """

    service_provision_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="serviceProvisionCode"),
    ] = pydantic.Field(default=None)
    """
    The code(s) that detail the conditions under which the healthcare service is available/offered.
    """

    eligibility: typing.Optional[typing.List[HealthcareServiceEligibility]] = (
        pydantic.Field(default=None)
    )
    """
    Does this service have specific eligibility requirements that need to be met in order to use the service?
    """

    program: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    Programs that this service is applicable to.
    """

    characteristic: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    Collection of characteristics (attributes).
    """

    communication: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    Some services are specifically made available in multiple languages, this property permits a directory to declare the languages this is offered in. Typically this is only provided where a service operates in communities with mixed languages used.
    """

    referral_method: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="referralMethod"),
    ] = pydantic.Field(default=None)
    """
    Ways that the service accepts referrals, if this is not provided then it is implied that no referral is required.
    """

    appointment_required: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="appointmentRequired")
    ] = pydantic.Field(default=None)
    """
    Indicates whether or not a prospective consumer will require an appointment for a particular service at a site to be provided by the Organization. Indicates if an appointment is required for access to this service.
    """

    available_time: typing_extensions.Annotated[
        typing.Optional[typing.List[HealthcareServiceAvailableTime]],
        FieldMetadata(alias="availableTime"),
    ] = pydantic.Field(default=None)
    """
    A collection of times that the Service Site is available.
    """

    not_available: typing_extensions.Annotated[
        typing.Optional[typing.List[HealthcareServiceNotAvailable]],
        FieldMetadata(alias="notAvailable"),
    ] = pydantic.Field(default=None)
    """
    The HealthcareService is not available during this period of time due to the provided reason.
    """

    availability_exceptions: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="availabilityExceptions")
    ] = pydantic.Field(default=None)
    """
    A description of site availability exceptions, e.g. public holiday availability. Succinctly describing all possible exceptions to normal site availability as details in the available Times and not available Times.
    """

    endpoint: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Technical endpoints providing access to services operated for the specific healthcare services defined at this resource.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
