# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .guidance_response_status import GuidanceResponseStatus
from .date_time import DateTime
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class GuidanceResponse(BaseResource):
    """
    A guidance response is the formal response to a guidance request, including any output parameters returned by the evaluation, as well as the description of any proposed actions to be taken.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["GuidanceResponse"], FieldMetadata(alias="resourceType")
    ] = "GuidanceResponse"
    request_identifier: typing_extensions.Annotated[
        typing.Optional[Identifier], FieldMetadata(alias="requestIdentifier")
    ] = pydantic.Field(default=None)
    """
    The identifier of the request associated with this response. If an identifier was given as part of the request, it will be reproduced here to enable the requester to more easily identify the response in a multi-request scenario.
    """

    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Allows a service to provide unique, business identifiers for the response.
    """

    module_uri: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="moduleUri")
    ] = pydantic.Field(default=None)
    """
    An identifier, CodeableConcept or canonical reference to the guidance that was requested.
    """

    module_canonical: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="moduleCanonical")
    ] = pydantic.Field(default=None)
    """
    An identifier, CodeableConcept or canonical reference to the guidance that was requested.
    """

    module_codeable_concept: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="moduleCodeableConcept")
    ] = pydantic.Field(default=None)
    """
    An identifier, CodeableConcept or canonical reference to the guidance that was requested.
    """

    status: typing.Optional[GuidanceResponseStatus] = pydantic.Field(default=None)
    """
    The status of the response. If the evaluation is completed successfully, the status will indicate success. However, in order to complete the evaluation, the engine may require more information. In this case, the status will be data-required, and the response will contain a description of the additional required information. If the evaluation completed successfully, but the engine determines that a potentially more accurate response could be provided if more data was available, the status will be data-requested, and the response will contain a description of the additional requested information.
    """

    subject: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The patient for which the request was processed.
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The encounter during which this response was created or to which the creation of this record is tightly associated.
    """

    occurrence_date_time: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="occurrenceDateTime")
    ] = pydantic.Field(default=None)
    """
    Indicates when the guidance response was processed.
    """

    performer: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Provides a reference to the device that performed the guidance.
    """

    reason_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="reasonCode")
    ] = pydantic.Field(default=None)
    """
    Describes the reason for the guidance response in coded or textual form.
    """

    reason_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="reasonReference")
    ] = pydantic.Field(default=None)
    """
    Indicates the reason the request was initiated. This is typically provided as a parameter to the evaluation and echoed by the service, although for some use cases, such as subscription- or event-based scenarios, it may provide an indication of the cause for the response.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Provides a mechanism to communicate additional information about the response.
    """

    evaluation_message: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="evaluationMessage"),
    ] = pydantic.Field(default=None)
    """
    Messages resulting from the evaluation of the artifact or artifacts. As part of evaluating the request, the engine may produce informational or warning messages. These messages will be provided by this element.
    """

    output_parameters: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="outputParameters")
    ] = pydantic.Field(default=None)
    """
    The output parameters of the evaluation, if any. Many modules will result in the return of specific resources such as procedure or communication requests that are returned as part of the operation result. However, modules may define specific outputs that would be returned as the result of the evaluation, and these would be returned in this element.
    """

    result: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The actions, if any, produced by the evaluation of the artifact.
    """

    data_requirement: typing_extensions.Annotated[
        typing.Optional[typing.List[DataRequirement]],
        FieldMetadata(alias="dataRequirement"),
    ] = pydantic.Field(default=None)
    """
    If the evaluation could not be completed due to lack of information, or additional information would potentially result in a more accurate response, this element will a description of the data required in order to proceed with the evaluation. A subsequent request to the service should include this data.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
