# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .group_type import GroupType
from .unsigned_int import UnsignedInt
from .group_characteristic import GroupCharacteristic
from .group_member import GroupMember
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Group(BaseResource):
    """
    Represents a defined collection of entities that may be discussed or acted upon collectively but which are not expected to act collectively, and are not formally or legally recognized; i.e. a collection of entities that isn't an Organization.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Group"], FieldMetadata(alias="resourceType")
    ] = "Group"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    A unique business identifier for this group.
    """

    active: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether the record for the group is available for use or is merely being retained for historical purposes.
    """

    type: typing.Optional[GroupType] = pydantic.Field(default=None)
    """
    Identifies the broad classification of the kind of resources the group includes.
    """

    actual: typing.Optional[bool] = pydantic.Field(default=None)
    """
    If true, indicates that the resource refers to a specific group of real individuals. If false, the group defines a set of intended individuals.
    """

    code: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Provides a specific type of resource the group includes; e.g. "cow", "syringe", etc.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A label assigned to the group for human identification and communication.
    """

    quantity: typing.Optional[UnsignedInt] = pydantic.Field(default=None)
    """
    A count of the number of resource instances that are part of the group.
    """

    managing_entity: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="managingEntity")
    ] = pydantic.Field(default=None)
    """
    Entity responsible for defining and maintaining Group characteristics and/or registered members.
    """

    characteristic: typing.Optional[typing.List[GroupCharacteristic]] = pydantic.Field(
        default=None
    )
    """
    Identifies traits whose presence r absence is shared by members of the group.
    """

    member: typing.Optional[typing.List[GroupMember]] = pydantic.Field(default=None)
    """
    Identifies the resource instances that are members of the group.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
