# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .goal_lifecycle_status import GoalLifecycleStatus
from .goal_target import GoalTarget
import datetime as dt
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Goal(BaseResource):
    """
    Describes the intended objective(s) for a patient, group or organization care, for example, weight loss, restoring an activity of daily living, obtaining herd immunity via immunization, meeting a process improvement objective, etc.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Goal"], FieldMetadata(alias="resourceType")
    ] = "Goal"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Business identifiers assigned to this goal by the performer or other systems which remain constant as the resource is updated and propagates from server to server.
    """

    lifecycle_status: typing_extensions.Annotated[
        typing.Optional[GoalLifecycleStatus], FieldMetadata(alias="lifecycleStatus")
    ] = pydantic.Field(default=None)
    """
    The state of the goal throughout its lifecycle.
    """

    achievement_status: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="achievementStatus")
    ] = pydantic.Field(default=None)
    """
    Describes the progression, or lack thereof, towards the goal against the target.
    """

    category: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    Indicates a category the goal falls within.
    """

    priority: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Identifies the mutually agreed level of importance associated with reaching/sustaining the goal.
    """

    description: CodeableConcept = pydantic.Field()
    """
    Human-readable and/or coded description of a specific desired objective of care, such as "control blood pressure" or "negotiate an obstacle course" or "dance with child at wedding".
    """

    subject: Reference = pydantic.Field()
    """
    Identifies the patient, group or organization for whom the goal is being established.
    """

    start_date: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="startDate")
    ] = pydantic.Field(default=None)
    """
    The date or event after which the goal should begin being pursued.
    """

    start_codeable_concept: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="startCodeableConcept")
    ] = pydantic.Field(default=None)
    """
    The date or event after which the goal should begin being pursued.
    """

    target: typing.Optional[typing.List[GoalTarget]] = pydantic.Field(default=None)
    """
    Indicates what should be done by when.
    """

    status_date: typing_extensions.Annotated[
        typing.Optional[dt.date], FieldMetadata(alias="statusDate")
    ] = pydantic.Field(default=None)
    """
    Identifies when the current status. I.e. When initially created, when achieved, when cancelled, etc.
    """

    status_reason: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="statusReason")
    ] = pydantic.Field(default=None)
    """
    Captures the reason for the current status.
    """

    expressed_by: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="expressedBy")
    ] = pydantic.Field(default=None)
    """
    Indicates whose goal this is - patient goal, practitioner goal, etc.
    """

    addresses: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The identified conditions and other health record elements that are intended to be addressed by the goal.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Any comments related to the goal.
    """

    outcome_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="outcomeCode"),
    ] = pydantic.Field(default=None)
    """
    Identifies the change (or lack of change) at the point when the status of the goal is assessed.
    """

    outcome_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="outcomeReference")
    ] = pydantic.Field(default=None)
    """
    Details of what's changed (or not changed).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
