# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .flag_status import FlagStatus
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Flag(BaseResource):
    """
    Prospective warnings of potential issues when providing care to the patient.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Flag"], FieldMetadata(alias="resourceType")
    ] = "Flag"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Business identifiers assigned to this flag by the performer or other systems which remain constant as the resource is updated and propagates from server to server.
    """

    status: typing.Optional[FlagStatus] = pydantic.Field(default=None)
    """
    Supports basic workflow.
    """

    category: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    Allows a flag to be divided into different categories like clinical, administrative etc. Intended to be used as a means of filtering which flags are displayed to particular user or in a given context.
    """

    code: CodeableConcept = pydantic.Field()
    """
    The coded value or textual component of the flag to display to the user.
    """

    subject: Reference = pydantic.Field()
    """
    The patient, location, group, organization, or practitioner etc. this is about record this flag is associated with.
    """

    period: typing.Optional[Period] = pydantic.Field(default=None)
    """
    The period of time from the activation of the flag to inactivation of the flag. If the flag is active, the end of the period should be unspecified.
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    This alert is only relevant during the encounter.
    """

    author: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The person, organization or device that created the flag.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
