# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .canonical import Canonical
from .uri import Uri
from .family_member_history_status import FamilyMemberHistoryStatus
from .date_time import DateTime
from .family_member_history_condition import FamilyMemberHistoryCondition
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class FamilyMemberHistory(BaseResource):
    """
    Significant health conditions for a person related to the patient relevant in the context of care for the patient.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["FamilyMemberHistory"], FieldMetadata(alias="resourceType")
    ] = "FamilyMemberHistory"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Business identifiers assigned to this family member history by the performer or other systems which remain constant as the resource is updated and propagates from server to server.
    """

    instantiates_canonical: typing_extensions.Annotated[
        typing.Optional[typing.List[Canonical]],
        FieldMetadata(alias="instantiatesCanonical"),
    ] = pydantic.Field(default=None)
    """
    The URL pointing to a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this FamilyMemberHistory.
    """

    instantiates_uri: typing_extensions.Annotated[
        typing.Optional[typing.List[Uri]], FieldMetadata(alias="instantiatesUri")
    ] = pydantic.Field(default=None)
    """
    The URL pointing to an externally maintained protocol, guideline, orderset or other definition that is adhered to in whole or in part by this FamilyMemberHistory.
    """

    status: typing.Optional[FamilyMemberHistoryStatus] = pydantic.Field(default=None)
    """
    A code specifying the status of the record of the family history of a specific family member.
    """

    data_absent_reason: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="dataAbsentReason")
    ] = pydantic.Field(default=None)
    """
    Describes why the family member's history is not available.
    """

    patient: Reference = pydantic.Field()
    """
    The person who this history concerns.
    """

    date: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date (and possibly time) when the family member history was recorded or last updated.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    This will either be a name or a description; e.g. "Aunt Susan", "my cousin with the red hair".
    """

    relationship: CodeableConcept = pydantic.Field()
    """
    The type of relationship this person has to the patient (father, mother, brother etc.).
    """

    sex: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The birth sex of the family member.
    """

    born_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="bornPeriod")
    ] = pydantic.Field(default=None)
    """
    The actual or approximate date of birth of the relative.
    """

    born_date: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="bornDate")
    ] = pydantic.Field(default=None)
    """
    The actual or approximate date of birth of the relative.
    """

    born_string: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="bornString")
    ] = pydantic.Field(default=None)
    """
    The actual or approximate date of birth of the relative.
    """

    age_age: typing_extensions.Annotated[
        typing.Optional[Age], FieldMetadata(alias="ageAge")
    ] = pydantic.Field(default=None)
    """
    The age of the relative at the time the family member history is recorded.
    """

    age_range: typing_extensions.Annotated[
        typing.Optional[Range], FieldMetadata(alias="ageRange")
    ] = pydantic.Field(default=None)
    """
    The age of the relative at the time the family member history is recorded.
    """

    age_string: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="ageString")
    ] = pydantic.Field(default=None)
    """
    The age of the relative at the time the family member history is recorded.
    """

    estimated_age: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="estimatedAge")
    ] = pydantic.Field(default=None)
    """
    If true, indicates that the age value specified is an estimated value.
    """

    deceased_boolean: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="deceasedBoolean")
    ] = pydantic.Field(default=None)
    """
    Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record.
    """

    deceased_age: typing_extensions.Annotated[
        typing.Optional[Age], FieldMetadata(alias="deceasedAge")
    ] = pydantic.Field(default=None)
    """
    Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record.
    """

    deceased_range: typing_extensions.Annotated[
        typing.Optional[Range], FieldMetadata(alias="deceasedRange")
    ] = pydantic.Field(default=None)
    """
    Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record.
    """

    deceased_date: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="deceasedDate")
    ] = pydantic.Field(default=None)
    """
    Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record.
    """

    deceased_string: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="deceasedString")
    ] = pydantic.Field(default=None)
    """
    Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record.
    """

    reason_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="reasonCode")
    ] = pydantic.Field(default=None)
    """
    Describes why the family member history occurred in coded or textual form.
    """

    reason_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="reasonReference")
    ] = pydantic.Field(default=None)
    """
    Indicates a Condition, Observation, AllergyIntolerance, or QuestionnaireResponse that justifies this family member history event.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    This property allows a non condition-specific note to the made about the related person. Ideally, the note would be in the condition property, but this is not always possible.
    """

    condition: typing.Optional[typing.List[FamilyMemberHistoryCondition]] = (
        pydantic.Field(default=None)
    )
    """
    The significant Conditions (or condition) that the family member had. This is a repeating section to allow a system to represent more than one condition per resource, though there is nothing stopping multiple resources - one per condition.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
