# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ...core.pydantic_utilities import UniversalBaseModel
import typing
import pydantic
from .uri import Uri
import typing_extensions
from ...core.serialization import FieldMetadata
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.pydantic_utilities import update_forward_refs


class Extension(UniversalBaseModel):
    """
    Optional Extension Element - found in all resources.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List["Extension"]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    url: typing.Optional[Uri] = pydantic.Field(default=None)
    """
    Source of the definition for the extension code - a logical name or a URL.
    """

    value_base_64_binary: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="valueBase64Binary")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_boolean: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="valueBoolean")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_canonical: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="valueCanonical")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_code: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="valueCode")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_date: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="valueDate")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="valueDateTime")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_decimal: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="valueDecimal")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_id: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="valueId")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_instant: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="valueInstant")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_integer: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="valueInteger")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_markdown: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="valueMarkdown")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_oid: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="valueOid")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_positive_int: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="valuePositiveInt")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_string: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="valueString")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="valueTime")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_unsigned_int: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="valueUnsignedInt")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_uri: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="valueUri")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_url: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="valueUrl")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_uuid: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="valueUuid")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_address: typing_extensions.Annotated[
        typing.Optional["Address"], FieldMetadata(alias="valueAddress")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_age: typing_extensions.Annotated[
        typing.Optional["Age"], FieldMetadata(alias="valueAge")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_annotation: typing_extensions.Annotated[
        typing.Optional["Annotation"], FieldMetadata(alias="valueAnnotation")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_attachment: typing_extensions.Annotated[
        typing.Optional["Attachment"], FieldMetadata(alias="valueAttachment")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_codeable_concept: typing_extensions.Annotated[
        typing.Optional["CodeableConcept"], FieldMetadata(alias="valueCodeableConcept")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_coding: typing_extensions.Annotated[
        typing.Optional["Coding"], FieldMetadata(alias="valueCoding")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_contact_point: typing_extensions.Annotated[
        typing.Optional["ContactPoint"], FieldMetadata(alias="valueContactPoint")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_count: typing_extensions.Annotated[
        typing.Optional["Count"], FieldMetadata(alias="valueCount")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_distance: typing_extensions.Annotated[
        typing.Optional["Distance"], FieldMetadata(alias="valueDistance")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_duration: typing_extensions.Annotated[
        typing.Optional["Duration"], FieldMetadata(alias="valueDuration")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_human_name: typing_extensions.Annotated[
        typing.Optional["HumanName"], FieldMetadata(alias="valueHumanName")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_identifier: typing_extensions.Annotated[
        typing.Optional["Identifier"], FieldMetadata(alias="valueIdentifier")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_money: typing_extensions.Annotated[
        typing.Optional["Money"], FieldMetadata(alias="valueMoney")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_period: typing_extensions.Annotated[
        typing.Optional["Period"], FieldMetadata(alias="valuePeriod")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_quantity: typing_extensions.Annotated[
        typing.Optional["Quantity"], FieldMetadata(alias="valueQuantity")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_range: typing_extensions.Annotated[
        typing.Optional["Range"], FieldMetadata(alias="valueRange")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_ratio: typing_extensions.Annotated[
        typing.Optional["Ratio"], FieldMetadata(alias="valueRatio")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_reference: typing_extensions.Annotated[
        typing.Optional["Reference"], FieldMetadata(alias="valueReference")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_sampled_data: typing_extensions.Annotated[
        typing.Optional["SampledData"], FieldMetadata(alias="valueSampledData")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_signature: typing_extensions.Annotated[
        typing.Optional["Signature"], FieldMetadata(alias="valueSignature")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_timing: typing_extensions.Annotated[
        typing.Optional["Timing"], FieldMetadata(alias="valueTiming")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_contact_detail: typing_extensions.Annotated[
        typing.Optional["ContactDetail"], FieldMetadata(alias="valueContactDetail")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_contributor: typing_extensions.Annotated[
        typing.Optional["Contributor"], FieldMetadata(alias="valueContributor")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_data_requirement: typing_extensions.Annotated[
        typing.Optional["DataRequirement"], FieldMetadata(alias="valueDataRequirement")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_expression: typing_extensions.Annotated[
        typing.Optional["Expression"], FieldMetadata(alias="valueExpression")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_parameter_definition: typing_extensions.Annotated[
        typing.Optional["ParameterDefinition"],
        FieldMetadata(alias="valueParameterDefinition"),
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_related_artifact: typing_extensions.Annotated[
        typing.Optional["RelatedArtifact"], FieldMetadata(alias="valueRelatedArtifact")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_trigger_definition: typing_extensions.Annotated[
        typing.Optional["TriggerDefinition"],
        FieldMetadata(alias="valueTriggerDefinition"),
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_usage_context: typing_extensions.Annotated[
        typing.Optional["UsageContext"], FieldMetadata(alias="valueUsageContext")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_dosage: typing_extensions.Annotated[
        typing.Optional["Dosage"], FieldMetadata(alias="valueDosage")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    value_meta: typing_extensions.Annotated[
        typing.Optional["Meta"], FieldMetadata(alias="valueMeta")
    ] = pydantic.Field(default=None)
    """
    Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .address import Address  # noqa: E402
from .age import Age  # noqa: E402
from .annotation import Annotation  # noqa: E402
from .attachment import Attachment  # noqa: E402
from .codeable_concept import CodeableConcept  # noqa: E402
from .coding import Coding  # noqa: E402
from .contact_detail import ContactDetail  # noqa: E402
from .contact_point import ContactPoint  # noqa: E402
from .contributor import Contributor  # noqa: E402
from .count import Count  # noqa: E402
from .data_requirement import DataRequirement  # noqa: E402
from .data_requirement_code_filter import DataRequirementCodeFilter  # noqa: E402
from .data_requirement_date_filter import DataRequirementDateFilter  # noqa: E402
from .data_requirement_sort import DataRequirementSort  # noqa: E402
from .distance import Distance  # noqa: E402
from .dosage import Dosage  # noqa: E402
from .dosage_dose_and_rate import DosageDoseAndRate  # noqa: E402
from .duration import Duration  # noqa: E402
from .expression import Expression  # noqa: E402
from .human_name import HumanName  # noqa: E402
from .identifier import Identifier  # noqa: E402
from .meta import Meta  # noqa: E402
from .money import Money  # noqa: E402
from .parameter_definition import ParameterDefinition  # noqa: E402
from .period import Period  # noqa: E402
from .quantity import Quantity  # noqa: E402
from .range import Range  # noqa: E402
from .ratio import Ratio  # noqa: E402
from .reference import Reference  # noqa: E402
from .related_artifact import RelatedArtifact  # noqa: E402
from .sampled_data import SampledData  # noqa: E402
from .signature import Signature  # noqa: E402
from .timing import Timing  # noqa: E402
from .timing_repeat import TimingRepeat  # noqa: E402
from .trigger_definition import TriggerDefinition  # noqa: E402
from .usage_context import UsageContext  # noqa: E402

update_forward_refs(Extension)
