# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .explanation_of_benefit_status import ExplanationOfBenefitStatus
from .code import Code
from .date_time import DateTime
from .explanation_of_benefit_related import ExplanationOfBenefitRelated
from .explanation_of_benefit_payee import ExplanationOfBenefitPayee
from .explanation_of_benefit_care_team import ExplanationOfBenefitCareTeam
from .explanation_of_benefit_supporting_info import ExplanationOfBenefitSupportingInfo
from .explanation_of_benefit_diagnosis import ExplanationOfBenefitDiagnosis
from .explanation_of_benefit_procedure import ExplanationOfBenefitProcedure
from .positive_int import PositiveInt
from .explanation_of_benefit_insurance import ExplanationOfBenefitInsurance
from .explanation_of_benefit_accident import ExplanationOfBenefitAccident
from .explanation_of_benefit_item import ExplanationOfBenefitItem
from .explanation_of_benefit_add_item import ExplanationOfBenefitAddItem
from .explanation_of_benefit_adjudication import ExplanationOfBenefitAdjudication
from .explanation_of_benefit_total import ExplanationOfBenefitTotal
from .explanation_of_benefit_payment import ExplanationOfBenefitPayment
from .explanation_of_benefit_process_note import ExplanationOfBenefitProcessNote
from .explanation_of_benefit_benefit_balance import ExplanationOfBenefitBenefitBalance
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ExplanationOfBenefit(BaseResource):
    """
    This resource provides: the claim details; adjudication details from the processing of a Claim; and optionally account balance information, for informing the subscriber of the benefits provided.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["ExplanationOfBenefit"], FieldMetadata(alias="resourceType")
    ] = "ExplanationOfBenefit"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    A unique identifier assigned to this explanation of benefit.
    """

    status: typing.Optional[ExplanationOfBenefitStatus] = pydantic.Field(default=None)
    """
    The status of the resource instance.
    """

    type: CodeableConcept = pydantic.Field()
    """
    The category of claim, e.g. oral, pharmacy, vision, institutional, professional.
    """

    sub_type: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="subType")
    ] = pydantic.Field(default=None)
    """
    A finer grained suite of claim type codes which may convey additional information such as Inpatient vs Outpatient and/or a specialty service.
    """

    use: typing.Optional[Code] = pydantic.Field(default=None)
    """
    A code to indicate whether the nature of the request is: to request adjudication of products and services previously rendered; or requesting authorization and adjudication for provision in the future; or requesting the non-binding adjudication of the listed products and services which could be provided in the future.
    """

    patient: Reference = pydantic.Field()
    """
    The party to whom the professional services and/or products have been supplied or are being considered and for whom actual for forecast reimbursement is sought.
    """

    billable_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="billablePeriod")
    ] = pydantic.Field(default=None)
    """
    The period for which charges are being submitted.
    """

    created: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date this resource was created.
    """

    enterer: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Individual who created the claim, predetermination or preauthorization.
    """

    insurer: Reference = pydantic.Field()
    """
    The party responsible for authorization, adjudication and reimbursement.
    """

    provider: Reference = pydantic.Field()
    """
    The provider which is responsible for the claim, predetermination or preauthorization.
    """

    priority: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The provider-required urgency of processing the request. Typical values include: stat, routine deferred.
    """

    funds_reserve_requested: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="fundsReserveRequested")
    ] = pydantic.Field(default=None)
    """
    A code to indicate whether and for whom funds are to be reserved for future claims.
    """

    funds_reserve: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="fundsReserve")
    ] = pydantic.Field(default=None)
    """
    A code, used only on a response to a preauthorization, to indicate whether the benefits payable have been reserved and for whom.
    """

    related: typing.Optional[typing.List[ExplanationOfBenefitRelated]] = pydantic.Field(
        default=None
    )
    """
    Other claims which are related to this claim such as prior submissions or claims for related services or for the same event.
    """

    prescription: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Prescription to support the dispensing of pharmacy, device or vision products.
    """

    original_prescription: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="originalPrescription")
    ] = pydantic.Field(default=None)
    """
    Original prescription which has been superseded by this prescription to support the dispensing of pharmacy services, medications or products.
    """

    payee: typing.Optional[ExplanationOfBenefitPayee] = pydantic.Field(default=None)
    """
    The party to be reimbursed for cost of the products and services according to the terms of the policy.
    """

    referral: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    A reference to a referral resource.
    """

    facility: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Facility where the services were provided.
    """

    claim: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The business identifier for the instance of the adjudication request: claim predetermination or preauthorization.
    """

    claim_response: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="claimResponse")
    ] = pydantic.Field(default=None)
    """
    The business identifier for the instance of the adjudication response: claim, predetermination or preauthorization response.
    """

    outcome: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The outcome of the claim, predetermination, or preauthorization processing.
    """

    disposition: typing.Optional[str] = pydantic.Field(default=None)
    """
    A human readable description of the status of the adjudication.
    """

    pre_auth_ref: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="preAuthRef")
    ] = pydantic.Field(default=None)
    """
    Reference from the Insurer which is used in later communications which refers to this adjudication.
    """

    pre_auth_ref_period: typing_extensions.Annotated[
        typing.Optional[typing.List[Period]], FieldMetadata(alias="preAuthRefPeriod")
    ] = pydantic.Field(default=None)
    """
    The timeframe during which the supplied preauthorization reference may be quoted on claims to obtain the adjudication as provided.
    """

    care_team: typing_extensions.Annotated[
        typing.Optional[typing.List[ExplanationOfBenefitCareTeam]],
        FieldMetadata(alias="careTeam"),
    ] = pydantic.Field(default=None)
    """
    The members of the team who provided the products and services.
    """

    supporting_info: typing_extensions.Annotated[
        typing.Optional[typing.List[ExplanationOfBenefitSupportingInfo]],
        FieldMetadata(alias="supportingInfo"),
    ] = pydantic.Field(default=None)
    """
    Additional information codes regarding exceptions, special considerations, the condition, situation, prior or concurrent issues.
    """

    diagnosis: typing.Optional[typing.List[ExplanationOfBenefitDiagnosis]] = (
        pydantic.Field(default=None)
    )
    """
    Information about diagnoses relevant to the claim items.
    """

    procedure: typing.Optional[typing.List[ExplanationOfBenefitProcedure]] = (
        pydantic.Field(default=None)
    )
    """
    Procedures performed on the patient relevant to the billing items with the claim.
    """

    precedence: typing.Optional[PositiveInt] = pydantic.Field(default=None)
    """
    This indicates the relative order of a series of EOBs related to different coverages for the same suite of services.
    """

    insurance: typing.List[ExplanationOfBenefitInsurance] = pydantic.Field()
    """
    Financial instruments for reimbursement for the health care products and services specified on the claim.
    """

    accident: typing.Optional[ExplanationOfBenefitAccident] = pydantic.Field(
        default=None
    )
    """
    Details of a accident which resulted in injuries which required the products and services listed in the claim.
    """

    item: typing.Optional[typing.List[ExplanationOfBenefitItem]] = pydantic.Field(
        default=None
    )
    """
    A claim line. Either a simple (a product or service) or a 'group' of details which can also be a simple items or groups of sub-details.
    """

    add_item: typing_extensions.Annotated[
        typing.Optional[typing.List[ExplanationOfBenefitAddItem]],
        FieldMetadata(alias="addItem"),
    ] = pydantic.Field(default=None)
    """
    The first-tier service adjudications for payor added product or service lines.
    """

    adjudication: typing.Optional[typing.List[ExplanationOfBenefitAdjudication]] = (
        pydantic.Field(default=None)
    )
    """
    The adjudication results which are presented at the header level rather than at the line-item or add-item levels.
    """

    total: typing.Optional[typing.List[ExplanationOfBenefitTotal]] = pydantic.Field(
        default=None
    )
    """
    Categorized monetary totals for the adjudication.
    """

    payment: typing.Optional[ExplanationOfBenefitPayment] = pydantic.Field(default=None)
    """
    Payment details for the adjudication of the claim.
    """

    form_code: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="formCode")
    ] = pydantic.Field(default=None)
    """
    A code for the form to be used for printing the content.
    """

    form: typing.Optional[Attachment] = pydantic.Field(default=None)
    """
    The actual form, by reference or inclusion, for printing the content or an EOB.
    """

    process_note: typing_extensions.Annotated[
        typing.Optional[typing.List[ExplanationOfBenefitProcessNote]],
        FieldMetadata(alias="processNote"),
    ] = pydantic.Field(default=None)
    """
    A note that describes or explains adjudication results in a human readable form.
    """

    benefit_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="benefitPeriod")
    ] = pydantic.Field(default=None)
    """
    The term of the benefits documented in this response.
    """

    benefit_balance: typing_extensions.Annotated[
        typing.Optional[typing.List[ExplanationOfBenefitBenefitBalance]],
        FieldMetadata(alias="benefitBalance"),
    ] = pydantic.Field(default=None)
    """
    Balance by Benefit Category.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
