# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
from .uri import Uri
import pydantic
from .evidence_variable_status import EvidenceVariableStatus
from .date_time import DateTime
from .markdown import Markdown
import datetime as dt
from .evidence_variable_type import EvidenceVariableType
from .evidence_variable_characteristic import EvidenceVariableCharacteristic
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class EvidenceVariable(BaseResource):
    """
    The EvidenceVariable resource describes a "PICO" element that knowledge (evidence, assertion, recommendation) is about.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["EvidenceVariable"], FieldMetadata(alias="resourceType")
    ] = "EvidenceVariable"
    url: typing.Optional[Uri] = pydantic.Field(default=None)
    """
    An absolute URI that is used to identify this evidence variable when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this evidence variable is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the evidence variable is stored on different servers.
    """

    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    A formal identifier that is used to identify this evidence variable when it is represented in other formats, or referenced in a specification, model, design or an instance.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The identifier that is used to identify this version of the evidence variable when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the evidence variable author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active artifacts.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A natural language name identifying the evidence variable. This name should be usable as an identifier for the module by machine processing applications such as code generation.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    A short, descriptive, user-friendly title for the evidence variable.
    """

    short_title: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="shortTitle")
    ] = pydantic.Field(default=None)
    """
    The short title provides an alternate title for use in informal descriptive contexts where the full, formal title is not necessary.
    """

    subtitle: typing.Optional[str] = pydantic.Field(default=None)
    """
    An explanatory or alternate title for the EvidenceVariable giving additional information about its content.
    """

    status: typing.Optional[EvidenceVariableStatus] = pydantic.Field(default=None)
    """
    The status of this evidence variable. Enables tracking the life-cycle of the content.
    """

    date: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date (and optionally time) when the evidence variable was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the evidence variable changes.
    """

    publisher: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the organization or individual that published the evidence variable.
    """

    contact: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    Contact details to assist a user in finding and communicating with the publisher.
    """

    description: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    A free text natural language description of the evidence variable from a consumer's perspective.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    A human-readable string to clarify or explain concepts about the resource.
    """

    use_context: typing_extensions.Annotated[
        typing.Optional[typing.List[UsageContext]], FieldMetadata(alias="useContext")
    ] = pydantic.Field(default=None)
    """
    The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate evidence variable instances.
    """

    jurisdiction: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A legal or geographic region in which the evidence variable is intended to be used.
    """

    copyright: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    A copyright statement relating to the evidence variable and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the evidence variable.
    """

    approval_date: typing_extensions.Annotated[
        typing.Optional[dt.date], FieldMetadata(alias="approvalDate")
    ] = pydantic.Field(default=None)
    """
    The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.
    """

    last_review_date: typing_extensions.Annotated[
        typing.Optional[dt.date], FieldMetadata(alias="lastReviewDate")
    ] = pydantic.Field(default=None)
    """
    The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.
    """

    effective_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="effectivePeriod")
    ] = pydantic.Field(default=None)
    """
    The period during which the evidence variable content was or is planned to be in active use.
    """

    topic: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    Descriptive topics related to the content of the EvidenceVariable. Topics provide a high-level categorization grouping types of EvidenceVariables that can be useful for filtering and searching.
    """

    author: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    An individiual or organization primarily involved in the creation and maintenance of the content.
    """

    editor: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    An individual or organization primarily responsible for internal coherence of the content.
    """

    reviewer: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    An individual or organization primarily responsible for review of some aspect of the content.
    """

    endorser: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    An individual or organization responsible for officially endorsing the content for use in some setting.
    """

    related_artifact: typing_extensions.Annotated[
        typing.Optional[typing.List[RelatedArtifact]],
        FieldMetadata(alias="relatedArtifact"),
    ] = pydantic.Field(default=None)
    """
    Related artifacts such as additional documentation, justification, or bibliographic references.
    """

    type: typing.Optional[EvidenceVariableType] = pydantic.Field(default=None)
    """
    The type of evidence element, a population, an exposure, or an outcome.
    """

    characteristic: typing.List[EvidenceVariableCharacteristic] = pydantic.Field()
    """
    A characteristic that defines the members of the evidence element. Multiple characteristics are applied with "and" semantics.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
