# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
from .uri import Uri
import pydantic
from .event_definition_status import EventDefinitionStatus
from .date_time import DateTime
from .markdown import Markdown
import datetime as dt
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class EventDefinition(BaseResource):
    """
    The EventDefinition resource provides a reusable description of when a particular event can occur.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["EventDefinition"], FieldMetadata(alias="resourceType")
    ] = "EventDefinition"
    url: typing.Optional[Uri] = pydantic.Field(default=None)
    """
    An absolute URI that is used to identify this event definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this event definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the event definition is stored on different servers.
    """

    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    A formal identifier that is used to identify this event definition when it is represented in other formats, or referenced in a specification, model, design or an instance.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The identifier that is used to identify this version of the event definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the event definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A natural language name identifying the event definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    A short, descriptive, user-friendly title for the event definition.
    """

    subtitle: typing.Optional[str] = pydantic.Field(default=None)
    """
    An explanatory or alternate title for the event definition giving additional information about its content.
    """

    status: typing.Optional[EventDefinitionStatus] = pydantic.Field(default=None)
    """
    The status of this event definition. Enables tracking the life-cycle of the content.
    """

    experimental: typing.Optional[bool] = pydantic.Field(default=None)
    """
    A Boolean value to indicate that this event definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.
    """

    subject_codeable_concept: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="subjectCodeableConcept")
    ] = pydantic.Field(default=None)
    """
    A code or group definition that describes the intended subject of the event definition.
    """

    subject_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="subjectReference")
    ] = pydantic.Field(default=None)
    """
    A code or group definition that describes the intended subject of the event definition.
    """

    date: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date (and optionally time) when the event definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the event definition changes.
    """

    publisher: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the organization or individual that published the event definition.
    """

    contact: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    Contact details to assist a user in finding and communicating with the publisher.
    """

    description: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    A free text natural language description of the event definition from a consumer's perspective.
    """

    use_context: typing_extensions.Annotated[
        typing.Optional[typing.List[UsageContext]], FieldMetadata(alias="useContext")
    ] = pydantic.Field(default=None)
    """
    The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate event definition instances.
    """

    jurisdiction: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A legal or geographic region in which the event definition is intended to be used.
    """

    purpose: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    Explanation of why this event definition is needed and why it has been designed as it has.
    """

    usage: typing.Optional[str] = pydantic.Field(default=None)
    """
    A detailed description of how the event definition is used from a clinical perspective.
    """

    copyright: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    A copyright statement relating to the event definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the event definition.
    """

    approval_date: typing_extensions.Annotated[
        typing.Optional[dt.date], FieldMetadata(alias="approvalDate")
    ] = pydantic.Field(default=None)
    """
    The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.
    """

    last_review_date: typing_extensions.Annotated[
        typing.Optional[dt.date], FieldMetadata(alias="lastReviewDate")
    ] = pydantic.Field(default=None)
    """
    The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.
    """

    effective_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="effectivePeriod")
    ] = pydantic.Field(default=None)
    """
    The period during which the event definition content was or is planned to be in active use.
    """

    topic: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    Descriptive topics related to the module. Topics provide a high-level categorization of the module that can be useful for filtering and searching.
    """

    author: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    An individiual or organization primarily involved in the creation and maintenance of the content.
    """

    editor: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    An individual or organization primarily responsible for internal coherence of the content.
    """

    reviewer: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    An individual or organization primarily responsible for review of some aspect of the content.
    """

    endorser: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    An individual or organization responsible for officially endorsing the content for use in some setting.
    """

    related_artifact: typing_extensions.Annotated[
        typing.Optional[typing.List[RelatedArtifact]],
        FieldMetadata(alias="relatedArtifact"),
    ] = pydantic.Field(default=None)
    """
    Related resources such as additional documentation, justification, or bibliographic references.
    """

    trigger: typing.List[TriggerDefinition] = pydantic.Field()
    """
    The trigger element defines when the event occurs. If more than one trigger condition is specified, the event fires whenever any one of the trigger conditions is met.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
