# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .episode_of_care_status import EpisodeOfCareStatus
from .episode_of_care_status_history import EpisodeOfCareStatusHistory
from .episode_of_care_diagnosis import EpisodeOfCareDiagnosis
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class EpisodeOfCare(BaseResource):
    """
    An association between a patient and an organization / healthcare provider(s) during which time encounters may occur. The managing organization assumes a level of responsibility for the patient during this time.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["EpisodeOfCare"], FieldMetadata(alias="resourceType")
    ] = "EpisodeOfCare"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    The EpisodeOfCare may be known by different identifiers for different contexts of use, such as when an external agency is tracking the Episode for funding purposes.
    """

    status: typing.Optional[EpisodeOfCareStatus] = pydantic.Field(default=None)
    """
    planned | waitlist | active | onhold | finished | cancelled.
    """

    status_history: typing_extensions.Annotated[
        typing.Optional[typing.List[EpisodeOfCareStatusHistory]],
        FieldMetadata(alias="statusHistory"),
    ] = pydantic.Field(default=None)
    """
    The history of statuses that the EpisodeOfCare has been through (without requiring processing the history of the resource).
    """

    type: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    A classification of the type of episode of care; e.g. specialist referral, disease management, type of funded care.
    """

    diagnosis: typing.Optional[typing.List[EpisodeOfCareDiagnosis]] = pydantic.Field(
        default=None
    )
    """
    The list of diagnosis relevant to this episode of care.
    """

    patient: Reference = pydantic.Field()
    """
    The patient who is the focus of this episode of care.
    """

    managing_organization: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="managingOrganization")
    ] = pydantic.Field(default=None)
    """
    The organization that has assumed the specific responsibilities for the specified duration.
    """

    period: typing.Optional[Period] = pydantic.Field(default=None)
    """
    The interval during which the managing organization assumes the defined responsibility.
    """

    referral_request: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="referralRequest")
    ] = pydantic.Field(default=None)
    """
    Referral Request(s) that are fulfilled by this EpisodeOfCare, incoming referrals.
    """

    care_manager: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="careManager")
    ] = pydantic.Field(default=None)
    """
    The practitioner that is the care manager/care coordinator for this patient.
    """

    team: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The list of practitioners that may be facilitating this episode of care for specific purposes.
    """

    account: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The set of accounts that may be used for billing for this EpisodeOfCare.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
