# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .code import Code
from .date_time import DateTime
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class EnrollmentRequest(BaseResource):
    """
    This resource provides the insurance enrollment details to the insurer regarding a specified coverage.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["EnrollmentRequest"], FieldMetadata(alias="resourceType")
    ] = "EnrollmentRequest"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    The Response business identifier.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The status of the resource instance.
    """

    created: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date when this resource was created.
    """

    insurer: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The Insurer who is target of the request.
    """

    provider: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The practitioner who is responsible for the services rendered to the patient.
    """

    candidate: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Patient Resource.
    """

    coverage: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Reference to the program or plan identification, underwriter or payor.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
