# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .endpoint_status import EndpointStatus
from .code import Code
from .url import Url
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Endpoint(BaseResource):
    """
    The technical details of an endpoint that can be used for electronic services, such as for web services providing XDS.b or a REST endpoint for another FHIR server. This may include any security context information.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Endpoint"], FieldMetadata(alias="resourceType")
    ] = "Endpoint"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Identifier for the organization that is used to identify the endpoint across multiple disparate systems.
    """

    status: typing.Optional[EndpointStatus] = pydantic.Field(default=None)
    """
    active | suspended | error | off | test.
    """

    connection_type: typing_extensions.Annotated[
        Coding, FieldMetadata(alias="connectionType")
    ] = pydantic.Field()
    """
    A coded value that represents the technical details of the usage of this endpoint, such as what WSDLs should be used in what way. (e.g. XDS.b/DICOM/cds-hook).
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A friendly name that this endpoint can be referred to with.
    """

    managing_organization: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="managingOrganization")
    ] = pydantic.Field(default=None)
    """
    The organization that manages this endpoint (even if technically another organization is hosting this in the cloud, it is the organization associated with the data).
    """

    contact: typing.Optional[typing.List[ContactPoint]] = pydantic.Field(default=None)
    """
    Contact details for a human to contact about the subscription. The primary use of this for system administrator troubleshooting.
    """

    period: typing.Optional[Period] = pydantic.Field(default=None)
    """
    The interval during which the endpoint is expected to be operational.
    """

    payload_type: typing_extensions.Annotated[
        typing.List[CodeableConcept], FieldMetadata(alias="payloadType")
    ] = pydantic.Field()
    """
    The payload type describes the acceptable content that can be communicated on the endpoint.
    """

    payload_mime_type: typing_extensions.Annotated[
        typing.Optional[typing.List[Code]], FieldMetadata(alias="payloadMimeType")
    ] = pydantic.Field(default=None)
    """
    The mime type to send the payload in - e.g. application/fhir+xml, application/fhir+json. If the mime type is not specified, then the sender could send any content (including no content depending on the connectionType).
    """

    address: typing.Optional[Url] = pydantic.Field(default=None)
    """
    The uri that describes the actual end-point to connect to.
    """

    header: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Additional headers / information to send as part of the notification.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
