# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class EncounterHospitalization(UniversalBaseModel):
    """
    An interaction between a patient and healthcare provider(s) for the purpose of providing healthcare service(s) or assessing the health status of a patient.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    pre_admission_identifier: typing_extensions.Annotated[
        typing.Optional[Identifier], FieldMetadata(alias="preAdmissionIdentifier")
    ] = pydantic.Field(default=None)
    """
    Pre-admission identifier.
    """

    origin: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The location/organization from which the patient came before admission.
    """

    admit_source: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="admitSource")
    ] = pydantic.Field(default=None)
    """
    From where patient was admitted (physician referral, transfer).
    """

    re_admission: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="reAdmission")
    ] = pydantic.Field(default=None)
    """
    Whether this hospitalization is a readmission and why if known.
    """

    diet_preference: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="dietPreference"),
    ] = pydantic.Field(default=None)
    """
    Diet preferences reported by the patient.
    """

    special_courtesy: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="specialCourtesy"),
    ] = pydantic.Field(default=None)
    """
    Special courtesies (VIP, board member).
    """

    special_arrangement: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="specialArrangement"),
    ] = pydantic.Field(default=None)
    """
    Any special requests that have been made for this hospitalization encounter, such as the provision of specific equipment or other things.
    """

    destination: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Location/organization to which the patient is discharged.
    """

    discharge_disposition: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="dischargeDisposition")
    ] = pydantic.Field(default=None)
    """
    Category or kind of location after discharge.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
