# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .encounter_status import EncounterStatus
from .encounter_status_history import EncounterStatusHistory
from .encounter_class_history import EncounterClassHistory
from .encounter_participant import EncounterParticipant
from .encounter_diagnosis import EncounterDiagnosis
from .encounter_hospitalization import EncounterHospitalization
from .encounter_location import EncounterLocation
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Encounter(BaseResource):
    """
    An interaction between a patient and healthcare provider(s) for the purpose of providing healthcare service(s) or assessing the health status of a patient.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Encounter"], FieldMetadata(alias="resourceType")
    ] = "Encounter"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Identifier(s) by which this encounter is known.
    """

    status: typing.Optional[EncounterStatus] = pydantic.Field(default=None)
    """
    planned | arrived | triaged | in-progress | onleave | finished | cancelled +.
    """

    status_history: typing_extensions.Annotated[
        typing.Optional[typing.List[EncounterStatusHistory]],
        FieldMetadata(alias="statusHistory"),
    ] = pydantic.Field(default=None)
    """
    The status history permits the encounter resource to contain the status history without needing to read through the historical versions of the resource, or even have the server store them.
    """

    class_: typing_extensions.Annotated[Coding, FieldMetadata(alias="class")] = (
        pydantic.Field()
    )
    """
    Concepts representing classification of patient encounter such as ambulatory (outpatient), inpatient, emergency, home health or others due to local variations.
    """

    class_history: typing_extensions.Annotated[
        typing.Optional[typing.List[EncounterClassHistory]],
        FieldMetadata(alias="classHistory"),
    ] = pydantic.Field(default=None)
    """
    The class history permits the tracking of the encounters transitions without needing to go through the resource history. This would be used for a case where an admission starts of as an emergency encounter, then transitions into an inpatient scenario. Doing this and not restarting a new encounter ensures that any lab/diagnostic results can more easily follow the patient and not require re-processing and not get lost or cancelled during a kind of discharge from emergency to inpatient.
    """

    type: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    Specific type of encounter (e.g. e-mail consultation, surgical day-care, skilled nursing, rehabilitation).
    """

    service_type: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="serviceType")
    ] = pydantic.Field(default=None)
    """
    Broad categorization of the service that is to be provided (e.g. cardiology).
    """

    priority: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Indicates the urgency of the encounter.
    """

    subject: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The patient or group present at the encounter.
    """

    episode_of_care: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="episodeOfCare")
    ] = pydantic.Field(default=None)
    """
    Where a specific encounter should be classified as a part of a specific episode(s) of care this field should be used. This association can facilitate grouping of related encounters together for a specific purpose, such as government reporting, issue tracking, association via a common problem. The association is recorded on the encounter as these are typically created after the episode of care and grouped on entry rather than editing the episode of care to append another encounter to it (the episode of care could span years).
    """

    based_on: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="basedOn")
    ] = pydantic.Field(default=None)
    """
    The request this encounter satisfies (e.g. incoming referral or procedure request).
    """

    participant: typing.Optional[typing.List[EncounterParticipant]] = pydantic.Field(
        default=None
    )
    """
    The list of people responsible for providing the service.
    """

    appointment: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The appointment that scheduled this encounter.
    """

    period: typing.Optional[Period] = pydantic.Field(default=None)
    """
    The start and end time of the encounter.
    """

    length: typing.Optional[Duration] = pydantic.Field(default=None)
    """
    Quantity of time the encounter lasted. This excludes the time during leaves of absence.
    """

    reason_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="reasonCode")
    ] = pydantic.Field(default=None)
    """
    Reason the encounter takes place, expressed as a code. For admissions, this can be used for a coded admission diagnosis.
    """

    reason_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="reasonReference")
    ] = pydantic.Field(default=None)
    """
    Reason the encounter takes place, expressed as a code. For admissions, this can be used for a coded admission diagnosis.
    """

    diagnosis: typing.Optional[typing.List[EncounterDiagnosis]] = pydantic.Field(
        default=None
    )
    """
    The list of diagnosis relevant to this encounter.
    """

    account: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The set of accounts that may be used for billing for this Encounter.
    """

    hospitalization: typing.Optional[EncounterHospitalization] = pydantic.Field(
        default=None
    )
    """
    Details about the admission to a healthcare service.
    """

    location: typing.Optional[typing.List[EncounterLocation]] = pydantic.Field(
        default=None
    )
    """
    List of locations where the patient has been during this encounter.
    """

    service_provider: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="serviceProvider")
    ] = pydantic.Field(default=None)
    """
    The organization that is primarily responsible for this Encounter's services. This MAY be the same as the organization on the Patient record, however it could be different, such as if the actor performing the services was from an external organization (which may be billed seperately) for an external consultation. Refer to the example bundle showing an abbreviated set of Encounters for a colonoscopy.
    """

    part_of: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="partOf")
    ] = pydantic.Field(default=None)
    """
    Another Encounter of which this encounter is a part of (administratively or in time).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
