# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .element_definition_representation_item import ElementDefinitionRepresentationItem
from .element_definition_slicing import ElementDefinitionSlicing
from .markdown import Markdown
from .unsigned_int import UnsignedInt
from .element_definition_base import ElementDefinitionBase
from .uri import Uri
from .element_definition_type import ElementDefinitionType
from .element_definition_example import ElementDefinitionExample
from .id import Id
from .element_definition_constraint import ElementDefinitionConstraint
from .element_definition_binding import ElementDefinitionBinding
from .element_definition_mapping import ElementDefinitionMapping
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ElementDefinition(UniversalBaseModel):
    """
    Captures constraints on each element within the resource, profile, or extension.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    path: typing.Optional[str] = pydantic.Field(default=None)
    """
    The path identifies the element and is expressed as a "."-separated list of ancestor elements, beginning with the name of the resource or extension.
    """

    representation: typing.Optional[
        typing.List[ElementDefinitionRepresentationItem]
    ] = pydantic.Field(default=None)
    """
    Codes that define how this element is represented in instances, when the deviation varies from the normal case.
    """

    slice_name: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="sliceName")
    ] = pydantic.Field(default=None)
    """
    The name of this element definition slice, when slicing is working. The name must be a token with no dots or spaces. This is a unique name referring to a specific set of constraints applied to this element, used to provide a name to different slices of the same element.
    """

    slice_is_constraining: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="sliceIsConstraining")
    ] = pydantic.Field(default=None)
    """
    If true, indicates that this slice definition is constraining a slice definition with the same name in an inherited profile. If false, the slice is not overriding any slice in an inherited profile. If missing, the slice might or might not be overriding a slice in an inherited profile, depending on the sliceName.
    """

    label: typing.Optional[str] = pydantic.Field(default=None)
    """
    A single preferred label which is the text to display beside the element indicating its meaning or to use to prompt for the element in a user display or form.
    """

    code: typing.Optional[typing.List[Coding]] = pydantic.Field(default=None)
    """
    A code that has the same meaning as the element in a particular terminology.
    """

    slicing: typing.Optional[ElementDefinitionSlicing] = pydantic.Field(default=None)
    """
    Indicates that the element is sliced into a set of alternative definitions (i.e. in a structure definition, there are multiple different constraints on a single element in the base resource). Slicing can be used in any resource that has cardinality ..\* on the base resource, or any resource with a choice of types. The set of slices is any elements that come after this in the element sequence that have the same path, until a shorter path occurs (the shorter path terminates the set).
    """

    short: typing.Optional[str] = pydantic.Field(default=None)
    """
    A concise description of what this element means (e.g. for use in autogenerated summaries).
    """

    definition: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    Provides a complete explanation of the meaning of the data element for human readability. For the case of elements derived from existing elements (e.g. constraints), the definition SHALL be consistent with the base definition, but convey the meaning of the element in the particular context of use of the resource. (Note: The text you are reading is specified in ElementDefinition.definition).
    """

    comment: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    Explanatory notes and implementation guidance about the data element, including notes about how to use the data properly, exceptions to proper use, etc. (Note: The text you are reading is specified in ElementDefinition.comment).
    """

    requirements: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    This element is for traceability of why the element was created and why the constraints exist as they do. This may be used to point to source materials or specifications that drove the structure of this element.
    """

    alias: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Identifies additional names by which this element might also be known.
    """

    min: typing.Optional[UnsignedInt] = pydantic.Field(default=None)
    """
    The minimum number of times this element SHALL appear in the instance.
    """

    max: typing.Optional[str] = pydantic.Field(default=None)
    """
    The maximum number of times this element is permitted to appear in the instance.
    """

    base: typing.Optional[ElementDefinitionBase] = pydantic.Field(default=None)
    """
    Information about the base definition of the element, provided to make it unnecessary for tools to trace the deviation of the element through the derived and related profiles. When the element definition is not the original definition of an element - i.g. either in a constraint on another type, or for elements from a super type in a snap shot - then the information in provided in the element definition may be different to the base definition. On the original definition of the element, it will be same.
    """

    content_reference: typing_extensions.Annotated[
        typing.Optional[Uri], FieldMetadata(alias="contentReference")
    ] = pydantic.Field(default=None)
    """
    Identifies an element defined elsewhere in the definition whose content rules should be applied to the current element. ContentReferences bring across all the rules that are in the ElementDefinition for the element, including definitions, cardinality constraints, bindings, invariants etc.
    """

    type: typing.Optional[typing.List[ElementDefinitionType]] = pydantic.Field(
        default=None
    )
    """
    The data type or resource that the value of this element is permitted to be.
    """

    default_value_base_64_binary: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="defaultValueBase64Binary")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_boolean: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="defaultValueBoolean")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_canonical: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="defaultValueCanonical")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_code: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="defaultValueCode")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_date: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="defaultValueDate")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="defaultValueDateTime")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_decimal: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="defaultValueDecimal")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_id: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="defaultValueId")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_instant: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="defaultValueInstant")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_integer: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="defaultValueInteger")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_markdown: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="defaultValueMarkdown")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_oid: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="defaultValueOid")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_positive_int: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="defaultValuePositiveInt")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_string: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="defaultValueString")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="defaultValueTime")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_unsigned_int: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="defaultValueUnsignedInt")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_uri: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="defaultValueUri")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_url: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="defaultValueUrl")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_uuid: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="defaultValueUuid")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_address: typing_extensions.Annotated[
        typing.Optional[Address], FieldMetadata(alias="defaultValueAddress")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_age: typing_extensions.Annotated[
        typing.Optional[Age], FieldMetadata(alias="defaultValueAge")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_annotation: typing_extensions.Annotated[
        typing.Optional[Annotation], FieldMetadata(alias="defaultValueAnnotation")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_attachment: typing_extensions.Annotated[
        typing.Optional[Attachment], FieldMetadata(alias="defaultValueAttachment")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_codeable_concept: typing_extensions.Annotated[
        typing.Optional[CodeableConcept],
        FieldMetadata(alias="defaultValueCodeableConcept"),
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_coding: typing_extensions.Annotated[
        typing.Optional[Coding], FieldMetadata(alias="defaultValueCoding")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_contact_point: typing_extensions.Annotated[
        typing.Optional[ContactPoint], FieldMetadata(alias="defaultValueContactPoint")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_count: typing_extensions.Annotated[
        typing.Optional[Count], FieldMetadata(alias="defaultValueCount")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_distance: typing_extensions.Annotated[
        typing.Optional[Distance], FieldMetadata(alias="defaultValueDistance")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_duration: typing_extensions.Annotated[
        typing.Optional[Duration], FieldMetadata(alias="defaultValueDuration")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_human_name: typing_extensions.Annotated[
        typing.Optional[HumanName], FieldMetadata(alias="defaultValueHumanName")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_identifier: typing_extensions.Annotated[
        typing.Optional[Identifier], FieldMetadata(alias="defaultValueIdentifier")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_money: typing_extensions.Annotated[
        typing.Optional[Money], FieldMetadata(alias="defaultValueMoney")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="defaultValuePeriod")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_quantity: typing_extensions.Annotated[
        typing.Optional[Quantity], FieldMetadata(alias="defaultValueQuantity")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_range: typing_extensions.Annotated[
        typing.Optional[Range], FieldMetadata(alias="defaultValueRange")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_ratio: typing_extensions.Annotated[
        typing.Optional[Ratio], FieldMetadata(alias="defaultValueRatio")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="defaultValueReference")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_sampled_data: typing_extensions.Annotated[
        typing.Optional[SampledData], FieldMetadata(alias="defaultValueSampledData")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_signature: typing_extensions.Annotated[
        typing.Optional[Signature], FieldMetadata(alias="defaultValueSignature")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_timing: typing_extensions.Annotated[
        typing.Optional[Timing], FieldMetadata(alias="defaultValueTiming")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_contact_detail: typing_extensions.Annotated[
        typing.Optional[ContactDetail], FieldMetadata(alias="defaultValueContactDetail")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_contributor: typing_extensions.Annotated[
        typing.Optional[Contributor], FieldMetadata(alias="defaultValueContributor")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_data_requirement: typing_extensions.Annotated[
        typing.Optional[DataRequirement],
        FieldMetadata(alias="defaultValueDataRequirement"),
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_expression: typing_extensions.Annotated[
        typing.Optional[Expression], FieldMetadata(alias="defaultValueExpression")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_parameter_definition: typing_extensions.Annotated[
        typing.Optional[ParameterDefinition],
        FieldMetadata(alias="defaultValueParameterDefinition"),
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_related_artifact: typing_extensions.Annotated[
        typing.Optional[RelatedArtifact],
        FieldMetadata(alias="defaultValueRelatedArtifact"),
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_trigger_definition: typing_extensions.Annotated[
        typing.Optional[TriggerDefinition],
        FieldMetadata(alias="defaultValueTriggerDefinition"),
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_usage_context: typing_extensions.Annotated[
        typing.Optional[UsageContext], FieldMetadata(alias="defaultValueUsageContext")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_dosage: typing_extensions.Annotated[
        typing.Optional[Dosage], FieldMetadata(alias="defaultValueDosage")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    default_value_meta: typing_extensions.Annotated[
        typing.Optional[Meta], FieldMetadata(alias="defaultValueMeta")
    ] = pydantic.Field(default=None)
    """
    The value that should be used if there is no value stated in the instance (e.g. 'if not otherwise specified, the abstract is false').
    """

    meaning_when_missing: typing_extensions.Annotated[
        typing.Optional[Markdown], FieldMetadata(alias="meaningWhenMissing")
    ] = pydantic.Field(default=None)
    """
    The Implicit meaning that is to be understood when this element is missing (e.g. 'when this element is missing, the period is ongoing').
    """

    order_meaning: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="orderMeaning")
    ] = pydantic.Field(default=None)
    """
    If present, indicates that the order of the repeating element has meaning and describes what that meaning is. If absent, it means that the order of the element has no meaning.
    """

    fixed_base_64_binary: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="fixedBase64Binary")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_boolean: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="fixedBoolean")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_canonical: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="fixedCanonical")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_code: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="fixedCode")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_date: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="fixedDate")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="fixedDateTime")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_decimal: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="fixedDecimal")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_id: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="fixedId")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_instant: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="fixedInstant")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_integer: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="fixedInteger")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_markdown: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="fixedMarkdown")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_oid: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="fixedOid")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_positive_int: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="fixedPositiveInt")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_string: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="fixedString")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="fixedTime")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_unsigned_int: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="fixedUnsignedInt")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_uri: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="fixedUri")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_url: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="fixedUrl")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_uuid: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="fixedUuid")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_address: typing_extensions.Annotated[
        typing.Optional[Address], FieldMetadata(alias="fixedAddress")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_age: typing_extensions.Annotated[
        typing.Optional[Age], FieldMetadata(alias="fixedAge")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_annotation: typing_extensions.Annotated[
        typing.Optional[Annotation], FieldMetadata(alias="fixedAnnotation")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_attachment: typing_extensions.Annotated[
        typing.Optional[Attachment], FieldMetadata(alias="fixedAttachment")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_codeable_concept: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="fixedCodeableConcept")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_coding: typing_extensions.Annotated[
        typing.Optional[Coding], FieldMetadata(alias="fixedCoding")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_contact_point: typing_extensions.Annotated[
        typing.Optional[ContactPoint], FieldMetadata(alias="fixedContactPoint")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_count: typing_extensions.Annotated[
        typing.Optional[Count], FieldMetadata(alias="fixedCount")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_distance: typing_extensions.Annotated[
        typing.Optional[Distance], FieldMetadata(alias="fixedDistance")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_duration: typing_extensions.Annotated[
        typing.Optional[Duration], FieldMetadata(alias="fixedDuration")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_human_name: typing_extensions.Annotated[
        typing.Optional[HumanName], FieldMetadata(alias="fixedHumanName")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_identifier: typing_extensions.Annotated[
        typing.Optional[Identifier], FieldMetadata(alias="fixedIdentifier")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_money: typing_extensions.Annotated[
        typing.Optional[Money], FieldMetadata(alias="fixedMoney")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="fixedPeriod")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_quantity: typing_extensions.Annotated[
        typing.Optional[Quantity], FieldMetadata(alias="fixedQuantity")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_range: typing_extensions.Annotated[
        typing.Optional[Range], FieldMetadata(alias="fixedRange")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_ratio: typing_extensions.Annotated[
        typing.Optional[Ratio], FieldMetadata(alias="fixedRatio")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="fixedReference")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_sampled_data: typing_extensions.Annotated[
        typing.Optional[SampledData], FieldMetadata(alias="fixedSampledData")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_signature: typing_extensions.Annotated[
        typing.Optional[Signature], FieldMetadata(alias="fixedSignature")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_timing: typing_extensions.Annotated[
        typing.Optional[Timing], FieldMetadata(alias="fixedTiming")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_contact_detail: typing_extensions.Annotated[
        typing.Optional[ContactDetail], FieldMetadata(alias="fixedContactDetail")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_contributor: typing_extensions.Annotated[
        typing.Optional[Contributor], FieldMetadata(alias="fixedContributor")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_data_requirement: typing_extensions.Annotated[
        typing.Optional[DataRequirement], FieldMetadata(alias="fixedDataRequirement")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_expression: typing_extensions.Annotated[
        typing.Optional[Expression], FieldMetadata(alias="fixedExpression")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_parameter_definition: typing_extensions.Annotated[
        typing.Optional[ParameterDefinition],
        FieldMetadata(alias="fixedParameterDefinition"),
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_related_artifact: typing_extensions.Annotated[
        typing.Optional[RelatedArtifact], FieldMetadata(alias="fixedRelatedArtifact")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_trigger_definition: typing_extensions.Annotated[
        typing.Optional[TriggerDefinition],
        FieldMetadata(alias="fixedTriggerDefinition"),
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_usage_context: typing_extensions.Annotated[
        typing.Optional[UsageContext], FieldMetadata(alias="fixedUsageContext")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_dosage: typing_extensions.Annotated[
        typing.Optional[Dosage], FieldMetadata(alias="fixedDosage")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    fixed_meta: typing_extensions.Annotated[
        typing.Optional[Meta], FieldMetadata(alias="fixedMeta")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that SHALL be exactly the value for this element in the instance. For purposes of comparison, non-significant whitespace is ignored, and all values must be an exact match (case and accent sensitive). Missing elements/attributes must also be missing.
    """

    pattern_base_64_binary: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="patternBase64Binary")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_boolean: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="patternBoolean")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_canonical: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="patternCanonical")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_code: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="patternCode")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_date: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="patternDate")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="patternDateTime")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_decimal: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="patternDecimal")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_id: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="patternId")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_instant: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="patternInstant")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_integer: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="patternInteger")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_markdown: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="patternMarkdown")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_oid: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="patternOid")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_positive_int: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="patternPositiveInt")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_string: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="patternString")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="patternTime")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_unsigned_int: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="patternUnsignedInt")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_uri: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="patternUri")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_url: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="patternUrl")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_uuid: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="patternUuid")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_address: typing_extensions.Annotated[
        typing.Optional[Address], FieldMetadata(alias="patternAddress")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_age: typing_extensions.Annotated[
        typing.Optional[Age], FieldMetadata(alias="patternAge")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_annotation: typing_extensions.Annotated[
        typing.Optional[Annotation], FieldMetadata(alias="patternAnnotation")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_attachment: typing_extensions.Annotated[
        typing.Optional[Attachment], FieldMetadata(alias="patternAttachment")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_codeable_concept: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="patternCodeableConcept")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_coding: typing_extensions.Annotated[
        typing.Optional[Coding], FieldMetadata(alias="patternCoding")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_contact_point: typing_extensions.Annotated[
        typing.Optional[ContactPoint], FieldMetadata(alias="patternContactPoint")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_count: typing_extensions.Annotated[
        typing.Optional[Count], FieldMetadata(alias="patternCount")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_distance: typing_extensions.Annotated[
        typing.Optional[Distance], FieldMetadata(alias="patternDistance")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_duration: typing_extensions.Annotated[
        typing.Optional[Duration], FieldMetadata(alias="patternDuration")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_human_name: typing_extensions.Annotated[
        typing.Optional[HumanName], FieldMetadata(alias="patternHumanName")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_identifier: typing_extensions.Annotated[
        typing.Optional[Identifier], FieldMetadata(alias="patternIdentifier")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_money: typing_extensions.Annotated[
        typing.Optional[Money], FieldMetadata(alias="patternMoney")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="patternPeriod")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_quantity: typing_extensions.Annotated[
        typing.Optional[Quantity], FieldMetadata(alias="patternQuantity")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_range: typing_extensions.Annotated[
        typing.Optional[Range], FieldMetadata(alias="patternRange")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_ratio: typing_extensions.Annotated[
        typing.Optional[Ratio], FieldMetadata(alias="patternRatio")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="patternReference")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_sampled_data: typing_extensions.Annotated[
        typing.Optional[SampledData], FieldMetadata(alias="patternSampledData")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_signature: typing_extensions.Annotated[
        typing.Optional[Signature], FieldMetadata(alias="patternSignature")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_timing: typing_extensions.Annotated[
        typing.Optional[Timing], FieldMetadata(alias="patternTiming")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_contact_detail: typing_extensions.Annotated[
        typing.Optional[ContactDetail], FieldMetadata(alias="patternContactDetail")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_contributor: typing_extensions.Annotated[
        typing.Optional[Contributor], FieldMetadata(alias="patternContributor")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_data_requirement: typing_extensions.Annotated[
        typing.Optional[DataRequirement], FieldMetadata(alias="patternDataRequirement")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_expression: typing_extensions.Annotated[
        typing.Optional[Expression], FieldMetadata(alias="patternExpression")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_parameter_definition: typing_extensions.Annotated[
        typing.Optional[ParameterDefinition],
        FieldMetadata(alias="patternParameterDefinition"),
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_related_artifact: typing_extensions.Annotated[
        typing.Optional[RelatedArtifact], FieldMetadata(alias="patternRelatedArtifact")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_trigger_definition: typing_extensions.Annotated[
        typing.Optional[TriggerDefinition],
        FieldMetadata(alias="patternTriggerDefinition"),
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_usage_context: typing_extensions.Annotated[
        typing.Optional[UsageContext], FieldMetadata(alias="patternUsageContext")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_dosage: typing_extensions.Annotated[
        typing.Optional[Dosage], FieldMetadata(alias="patternDosage")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    pattern_meta: typing_extensions.Annotated[
        typing.Optional[Meta], FieldMetadata(alias="patternMeta")
    ] = pydantic.Field(default=None)
    """
    Specifies a value that the value in the instance SHALL follow - that is, any value in the pattern must be found in the instance. Other additional values may be found too. This is effectively constraint by example. When pattern[x] is used to constrain a primitive, it means that the value provided in the pattern[x] must match the instance value exactly. When pattern[x] is used to constrain an array, it means that each element provided in the pattern[x] array must (recursively) match at least one element from the instance array. When pattern[x] is used to constrain a complex object, it means that each property in the pattern must be present in the complex object, and its value must recursively match -- i.e., 1. If primitive: it must match exactly the pattern value 2. If a complex object: it must match (recursively) the pattern value 3. If an array: it must match (recursively) the pattern value.
    """

    example: typing.Optional[typing.List[ElementDefinitionExample]] = pydantic.Field(
        default=None
    )
    """
    A sample value for this element demonstrating the type of information that would typically be found in the element.
    """

    min_value_date: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="minValueDate")
    ] = pydantic.Field(default=None)
    """
    The minimum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.
    """

    min_value_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="minValueDateTime")
    ] = pydantic.Field(default=None)
    """
    The minimum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.
    """

    min_value_instant: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="minValueInstant")
    ] = pydantic.Field(default=None)
    """
    The minimum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.
    """

    min_value_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="minValueTime")
    ] = pydantic.Field(default=None)
    """
    The minimum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.
    """

    min_value_decimal: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="minValueDecimal")
    ] = pydantic.Field(default=None)
    """
    The minimum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.
    """

    min_value_integer: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="minValueInteger")
    ] = pydantic.Field(default=None)
    """
    The minimum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.
    """

    min_value_positive_int: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="minValuePositiveInt")
    ] = pydantic.Field(default=None)
    """
    The minimum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.
    """

    min_value_unsigned_int: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="minValueUnsignedInt")
    ] = pydantic.Field(default=None)
    """
    The minimum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.
    """

    min_value_quantity: typing_extensions.Annotated[
        typing.Optional[Quantity], FieldMetadata(alias="minValueQuantity")
    ] = pydantic.Field(default=None)
    """
    The minimum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.
    """

    max_value_date: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="maxValueDate")
    ] = pydantic.Field(default=None)
    """
    The maximum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.
    """

    max_value_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="maxValueDateTime")
    ] = pydantic.Field(default=None)
    """
    The maximum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.
    """

    max_value_instant: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="maxValueInstant")
    ] = pydantic.Field(default=None)
    """
    The maximum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.
    """

    max_value_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="maxValueTime")
    ] = pydantic.Field(default=None)
    """
    The maximum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.
    """

    max_value_decimal: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="maxValueDecimal")
    ] = pydantic.Field(default=None)
    """
    The maximum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.
    """

    max_value_integer: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="maxValueInteger")
    ] = pydantic.Field(default=None)
    """
    The maximum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.
    """

    max_value_positive_int: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="maxValuePositiveInt")
    ] = pydantic.Field(default=None)
    """
    The maximum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.
    """

    max_value_unsigned_int: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="maxValueUnsignedInt")
    ] = pydantic.Field(default=None)
    """
    The maximum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.
    """

    max_value_quantity: typing_extensions.Annotated[
        typing.Optional[Quantity], FieldMetadata(alias="maxValueQuantity")
    ] = pydantic.Field(default=None)
    """
    The maximum allowed value for the element. The value is inclusive. This is allowed for the types date, dateTime, instant, time, decimal, integer, and Quantity.
    """

    max_length: typing_extensions.Annotated[
        typing.Optional[int], FieldMetadata(alias="maxLength")
    ] = pydantic.Field(default=None)
    """
    Indicates the maximum length in characters that is permitted to be present in conformant instances and which is expected to be supported by conformant consumers that support the element.
    """

    condition: typing.Optional[typing.List[Id]] = pydantic.Field(default=None)
    """
    A reference to an invariant that may make additional statements about the cardinality or value in the instance.
    """

    constraint: typing.Optional[typing.List[ElementDefinitionConstraint]] = (
        pydantic.Field(default=None)
    )
    """
    Formal constraints such as co-occurrence and other constraints that can be computationally evaluated within the context of the instance.
    """

    must_support: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="mustSupport")
    ] = pydantic.Field(default=None)
    """
    If true, implementations that produce or consume resources SHALL provide "support" for the element in some meaningful way. If false, the element may be ignored and not supported. If false, whether to populate or use the data element in any way is at the discretion of the implementation.
    """

    is_modifier: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="isModifier")
    ] = pydantic.Field(default=None)
    """
    If true, the value of this element affects the interpretation of the element or resource that contains it, and the value of the element cannot be ignored. Typically, this is used for status, negation and qualification codes. The effect of this is that the element cannot be ignored by systems: they SHALL either recognize the element and process it, and/or a pre-determination has been made that it is not relevant to their particular system.
    """

    is_modifier_reason: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="isModifierReason")
    ] = pydantic.Field(default=None)
    """
    Explains how that element affects the interpretation of the resource or element that contains it.
    """

    is_summary: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="isSummary")
    ] = pydantic.Field(default=None)
    """
    Whether the element should be included if a client requests a search with the parameter \_summary=true.
    """

    binding: typing.Optional[ElementDefinitionBinding] = pydantic.Field(default=None)
    """
    Binds to a value set if this element is coded (code, Coding, CodeableConcept, Quantity), or the data types (string, uri).
    """

    mapping: typing.Optional[typing.List[ElementDefinitionMapping]] = pydantic.Field(
        default=None
    )
    """
    Identifies a concept from an external specification that roughly corresponds to this element.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
