# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
from .uri import Uri
import pydantic
from .effect_evidence_synthesis_status import EffectEvidenceSynthesisStatus
from .date_time import DateTime
from .markdown import Markdown
import datetime as dt
from .effect_evidence_synthesis_sample_size import EffectEvidenceSynthesisSampleSize
from .effect_evidence_synthesis_results_by_exposure import (
    EffectEvidenceSynthesisResultsByExposure,
)
from .effect_evidence_synthesis_effect_estimate import (
    EffectEvidenceSynthesisEffectEstimate,
)
from .effect_evidence_synthesis_certainty import EffectEvidenceSynthesisCertainty
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class EffectEvidenceSynthesis(BaseResource):
    """
    The EffectEvidenceSynthesis resource describes the difference in an outcome between exposures states in a population where the effect estimate is derived from a combination of research studies.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["EffectEvidenceSynthesis"], FieldMetadata(alias="resourceType")
    ] = "EffectEvidenceSynthesis"
    url: typing.Optional[Uri] = pydantic.Field(default=None)
    """
    An absolute URI that is used to identify this effect evidence synthesis when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this effect evidence synthesis is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the effect evidence synthesis is stored on different servers.
    """

    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    A formal identifier that is used to identify this effect evidence synthesis when it is represented in other formats, or referenced in a specification, model, design or an instance.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The identifier that is used to identify this version of the effect evidence synthesis when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the effect evidence synthesis author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A natural language name identifying the effect evidence synthesis. This name should be usable as an identifier for the module by machine processing applications such as code generation.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    A short, descriptive, user-friendly title for the effect evidence synthesis.
    """

    status: typing.Optional[EffectEvidenceSynthesisStatus] = pydantic.Field(
        default=None
    )
    """
    The status of this effect evidence synthesis. Enables tracking the life-cycle of the content.
    """

    date: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date (and optionally time) when the effect evidence synthesis was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the effect evidence synthesis changes.
    """

    publisher: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the organization or individual that published the effect evidence synthesis.
    """

    contact: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    Contact details to assist a user in finding and communicating with the publisher.
    """

    description: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    A free text natural language description of the effect evidence synthesis from a consumer's perspective.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    A human-readable string to clarify or explain concepts about the resource.
    """

    use_context: typing_extensions.Annotated[
        typing.Optional[typing.List[UsageContext]], FieldMetadata(alias="useContext")
    ] = pydantic.Field(default=None)
    """
    The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate effect evidence synthesis instances.
    """

    jurisdiction: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A legal or geographic region in which the effect evidence synthesis is intended to be used.
    """

    copyright: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    A copyright statement relating to the effect evidence synthesis and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the effect evidence synthesis.
    """

    approval_date: typing_extensions.Annotated[
        typing.Optional[dt.date], FieldMetadata(alias="approvalDate")
    ] = pydantic.Field(default=None)
    """
    The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.
    """

    last_review_date: typing_extensions.Annotated[
        typing.Optional[dt.date], FieldMetadata(alias="lastReviewDate")
    ] = pydantic.Field(default=None)
    """
    The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.
    """

    effective_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="effectivePeriod")
    ] = pydantic.Field(default=None)
    """
    The period during which the effect evidence synthesis content was or is planned to be in active use.
    """

    topic: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    Descriptive topics related to the content of the EffectEvidenceSynthesis. Topics provide a high-level categorization grouping types of EffectEvidenceSynthesiss that can be useful for filtering and searching.
    """

    author: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    An individiual or organization primarily involved in the creation and maintenance of the content.
    """

    editor: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    An individual or organization primarily responsible for internal coherence of the content.
    """

    reviewer: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    An individual or organization primarily responsible for review of some aspect of the content.
    """

    endorser: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    An individual or organization responsible for officially endorsing the content for use in some setting.
    """

    related_artifact: typing_extensions.Annotated[
        typing.Optional[typing.List[RelatedArtifact]],
        FieldMetadata(alias="relatedArtifact"),
    ] = pydantic.Field(default=None)
    """
    Related artifacts such as additional documentation, justification, or bibliographic references.
    """

    synthesis_type: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="synthesisType")
    ] = pydantic.Field(default=None)
    """
    Type of synthesis eg meta-analysis.
    """

    study_type: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="studyType")
    ] = pydantic.Field(default=None)
    """
    Type of study eg randomized trial.
    """

    population: Reference = pydantic.Field()
    """
    A reference to a EvidenceVariable resource that defines the population for the research.
    """

    exposure: Reference = pydantic.Field()
    """
    A reference to a EvidenceVariable resource that defines the exposure for the research.
    """

    exposure_alternative: typing_extensions.Annotated[
        Reference, FieldMetadata(alias="exposureAlternative")
    ] = pydantic.Field()
    """
    A reference to a EvidenceVariable resource that defines the comparison exposure for the research.
    """

    outcome: Reference = pydantic.Field()
    """
    A reference to a EvidenceVariable resomece that defines the outcome for the research.
    """

    sample_size: typing_extensions.Annotated[
        typing.Optional[EffectEvidenceSynthesisSampleSize],
        FieldMetadata(alias="sampleSize"),
    ] = pydantic.Field(default=None)
    """
    A description of the size of the sample involved in the synthesis.
    """

    results_by_exposure: typing_extensions.Annotated[
        typing.Optional[typing.List[EffectEvidenceSynthesisResultsByExposure]],
        FieldMetadata(alias="resultsByExposure"),
    ] = pydantic.Field(default=None)
    """
    A description of the results for each exposure considered in the effect estimate.
    """

    effect_estimate: typing_extensions.Annotated[
        typing.Optional[typing.List[EffectEvidenceSynthesisEffectEstimate]],
        FieldMetadata(alias="effectEstimate"),
    ] = pydantic.Field(default=None)
    """
    The estimated effect of the exposure variant.
    """

    certainty: typing.Optional[typing.List[EffectEvidenceSynthesisCertainty]] = (
        pydantic.Field(default=None)
    )
    """
    A description of the certainty of the effect estimate.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
