# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .document_reference_status import DocumentReferenceStatus
from .code import Code
from .instant import Instant
from .document_reference_relates_to import DocumentReferenceRelatesTo
from .document_reference_content import DocumentReferenceContent
from .document_reference_context import DocumentReferenceContext
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class DocumentReference(BaseResource):
    """
    A reference to a document of any kind for any purpose. Provides metadata about the document so that the document can be discovered and managed. The scope of a document is any seralized object with a mime-type, so includes formal patient centric documents (CDA), cliical notes, scanned paper, and non-patient specific documents like policy text.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["DocumentReference"], FieldMetadata(alias="resourceType")
    ] = "DocumentReference"
    master_identifier: typing_extensions.Annotated[
        typing.Optional[Identifier], FieldMetadata(alias="masterIdentifier")
    ] = pydantic.Field(default=None)
    """
    Document identifier as assigned by the source of the document. This identifier is specific to this version of the document. This unique identifier may be used elsewhere to identify this version of the document.
    """

    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Other identifiers associated with the document, including version independent identifiers.
    """

    status: typing.Optional[DocumentReferenceStatus] = pydantic.Field(default=None)
    """
    The status of this document reference.
    """

    doc_status: typing_extensions.Annotated[
        typing.Optional[Code], FieldMetadata(alias="docStatus")
    ] = pydantic.Field(default=None)
    """
    The status of the underlying document.
    """

    type: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Specifies the particular kind of document referenced (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the document referenced.
    """

    category: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A categorization for the type of document referenced - helps for indexing and searching. This may be implied by or derived from the code specified in the DocumentReference.type.
    """

    subject: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Who or what the document is about. The document can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of farm animals, or a set of patients that share a common exposure).
    """

    date: typing.Optional[Instant] = pydantic.Field(default=None)
    """
    When the document reference was created.
    """

    author: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Identifies who is responsible for adding the information to the document.
    """

    authenticator: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Which person or organization authenticates that this document is valid.
    """

    custodian: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Identifies the organization or group who is responsible for ongoing maintenance of and access to the document.
    """

    relates_to: typing_extensions.Annotated[
        typing.Optional[typing.List[DocumentReferenceRelatesTo]],
        FieldMetadata(alias="relatesTo"),
    ] = pydantic.Field(default=None)
    """
    Relationships that this document has with other document references that already exist.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Human-readable description of the source document.
    """

    security_label: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="securityLabel"),
    ] = pydantic.Field(default=None)
    """
    A set of Security-Tag codes specifying the level of privacy/security of the Document. Note that DocumentReference.meta.security contains the security labels of the "reference" to the document, while DocumentReference.securityLabel contains a snapshot of the security labels on the document the reference refers to.
    """

    content: typing.List[DocumentReferenceContent] = pydantic.Field()
    """
    The document and format referenced. There may be multiple content element repetitions, each with a different format.
    """

    context: typing.Optional[DocumentReferenceContext] = pydantic.Field(default=None)
    """
    The clinical context in which the document was prepared.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
