# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .document_manifest_status import DocumentManifestStatus
from .date_time import DateTime
from .uri import Uri
from .document_manifest_related import DocumentManifestRelated
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class DocumentManifest(BaseResource):
    """
    A collection of documents compiled for a purpose together with metadata that applies to the collection.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["DocumentManifest"], FieldMetadata(alias="resourceType")
    ] = "DocumentManifest"
    master_identifier: typing_extensions.Annotated[
        typing.Optional[Identifier], FieldMetadata(alias="masterIdentifier")
    ] = pydantic.Field(default=None)
    """
    A single identifier that uniquely identifies this manifest. Principally used to refer to the manifest in non-FHIR contexts.
    """

    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Other identifiers associated with the document manifest, including version independent identifiers.
    """

    status: typing.Optional[DocumentManifestStatus] = pydantic.Field(default=None)
    """
    The status of this document manifest.
    """

    type: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The code specifying the type of clinical activity that resulted in placing the associated content into the DocumentManifest.
    """

    subject: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Who or what the set of documents is about. The documents can be about a person, (patient or healthcare practitioner), a device (i.e. machine) or even a group of subjects (such as a document about a herd of farm animals, or a set of patients that share a common exposure). If the documents cross more than one subject, then more than one subject is allowed here (unusual use case).
    """

    created: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    When the document manifest was created for submission to the server (not necessarily the same thing as the actual resource last modified time, since it may be modified, replicated, etc.).
    """

    author: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Identifies who is the author of the manifest. Manifest author is not necessarly the author of the references included.
    """

    recipient: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    A patient, practitioner, or organization for which this set of documents is intended.
    """

    source: typing.Optional[Uri] = pydantic.Field(default=None)
    """
    Identifies the source system, application, or software that produced the document manifest.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Human-readable description of the source document. This is sometimes known as the "title".
    """

    content: typing.List[Reference] = pydantic.Field()
    """
    The list of Resources that consist of the parts of this manifest.
    """

    related: typing.Optional[typing.List[DocumentManifestRelated]] = pydantic.Field(
        default=None
    )
    """
    Related identifiers or resources associated with the DocumentManifest.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
