# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .diagnostic_report_status import DiagnosticReportStatus
from .instant import Instant
from .diagnostic_report_media import DiagnosticReportMedia
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class DiagnosticReport(BaseResource):
    """
    The findings and interpretation of diagnostic tests performed on patients, groups of patients, devices, and locations, and/or specimens derived from these. The report includes clinical context such as requesting and provider information, and some mix of atomic results, images, textual and coded interpretations, and formatted representation of diagnostic reports.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["DiagnosticReport"], FieldMetadata(alias="resourceType")
    ] = "DiagnosticReport"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Identifiers assigned to this report by the performer or other systems.
    """

    based_on: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="basedOn")
    ] = pydantic.Field(default=None)
    """
    Details concerning a service requested.
    """

    status: typing.Optional[DiagnosticReportStatus] = pydantic.Field(default=None)
    """
    The status of the diagnostic report.
    """

    category: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A code that classifies the clinical discipline, department or diagnostic service that created the report (e.g. cardiology, biochemistry, hematology, MRI). This is used for searching, sorting and display purposes.
    """

    code: CodeableConcept = pydantic.Field()
    """
    A code or name that describes this diagnostic report.
    """

    subject: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The subject of the report. Usually, but not always, this is a patient. However, diagnostic services also perform analyses on specimens collected from a variety of other sources.
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The healthcare event (e.g. a patient and healthcare provider interaction) which this DiagnosticReport is about.
    """

    effective_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="effectiveDateTime")
    ] = pydantic.Field(default=None)
    """
    The time or time-period the observed values are related to. When the subject of the report is a patient, this is usually either the time of the procedure or of specimen collection(s), but very often the source of the date/time is not known, only the date/time itself.
    """

    effective_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="effectivePeriod")
    ] = pydantic.Field(default=None)
    """
    The time or time-period the observed values are related to. When the subject of the report is a patient, this is usually either the time of the procedure or of specimen collection(s), but very often the source of the date/time is not known, only the date/time itself.
    """

    issued: typing.Optional[Instant] = pydantic.Field(default=None)
    """
    The date and time that this version of the report was made available to providers, typically after the report was reviewed and verified.
    """

    performer: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The diagnostic service that is responsible for issuing the report.
    """

    results_interpreter: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="resultsInterpreter"),
    ] = pydantic.Field(default=None)
    """
    The practitioner or organization that is responsible for the report's conclusions and interpretations.
    """

    specimen: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Details about the specimens on which this diagnostic report is based.
    """

    result: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    [Observations](observation.html) that are part of this diagnostic report.
    """

    imaging_study: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="imagingStudy")
    ] = pydantic.Field(default=None)
    """
    One or more links to full details of any imaging performed during the diagnostic investigation. Typically, this is imaging performed by DICOM enabled modalities, but this is not required. A fully enabled PACS viewer can use this information to provide views of the source images.
    """

    media: typing.Optional[typing.List[DiagnosticReportMedia]] = pydantic.Field(
        default=None
    )
    """
    A list of key images associated with this report. The images are generally created during the diagnostic process, and may be directly of the patient, or of treated specimens (i.e. slides of interest).
    """

    conclusion: typing.Optional[str] = pydantic.Field(default=None)
    """
    Concise and clinically contextualized summary conclusion (interpretation/impression) of the diagnostic report.
    """

    conclusion_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="conclusionCode"),
    ] = pydantic.Field(default=None)
    """
    One or more codes that represent the summary conclusion (interpretation/impression) of the diagnostic report.
    """

    presented_form: typing_extensions.Annotated[
        typing.Optional[typing.List[Attachment]], FieldMetadata(alias="presentedForm")
    ] = pydantic.Field(default=None)
    """
    Rich text representation of the entire result as issued by the diagnostic service. Multiple formats are allowed but they SHALL be semantically equivalent.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
