# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .device_use_statement_status import DeviceUseStatementStatus
from .date_time import DateTime
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class DeviceUseStatement(BaseResource):
    """
    A record of a device being used by a patient where the record is the result of a report from the patient or another clinician.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["DeviceUseStatement"], FieldMetadata(alias="resourceType")
    ] = "DeviceUseStatement"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    An external identifier for this statement such as an IRI.
    """

    based_on: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="basedOn")
    ] = pydantic.Field(default=None)
    """
    A plan, proposal or order that is fulfilled in whole or in part by this DeviceUseStatement.
    """

    status: typing.Optional[DeviceUseStatementStatus] = pydantic.Field(default=None)
    """
    A code representing the patient or other source's judgment about the state of the device used that this statement is about. Generally this will be active or completed.
    """

    subject: Reference = pydantic.Field()
    """
    The patient who used the device.
    """

    derived_from: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="derivedFrom")
    ] = pydantic.Field(default=None)
    """
    Allows linking the DeviceUseStatement to the underlying Request, or to other information that supports or is used to derive the DeviceUseStatement.
    """

    timing_timing: typing_extensions.Annotated[
        typing.Optional[Timing], FieldMetadata(alias="timingTiming")
    ] = pydantic.Field(default=None)
    """
    How often the device was used.
    """

    timing_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="timingPeriod")
    ] = pydantic.Field(default=None)
    """
    How often the device was used.
    """

    timing_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="timingDateTime")
    ] = pydantic.Field(default=None)
    """
    How often the device was used.
    """

    recorded_on: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="recordedOn")
    ] = pydantic.Field(default=None)
    """
    The time at which the statement was made/recorded.
    """

    source: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Who reported the device was being used by the patient.
    """

    device: Reference = pydantic.Field()
    """
    The details of the device used.
    """

    reason_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="reasonCode")
    ] = pydantic.Field(default=None)
    """
    Reason or justification for the use of the device.
    """

    reason_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="reasonReference")
    ] = pydantic.Field(default=None)
    """
    Indicates another resource whose existence justifies this DeviceUseStatement.
    """

    body_site: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="bodySite")
    ] = pydantic.Field(default=None)
    """
    Indicates the anotomic location on the subject's body where the device was used ( i.e. the target).
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Details about the device statement that were not represented at all or sufficiently in one of the attributes provided in a class. These may include for example a comment, an instruction, or a note associated with the statement.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
