# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .canonical import Canonical
from .uri import Uri
from .code import Code
from .device_request_parameter import DeviceRequestParameter
from .date_time import DateTime
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class DeviceRequest(BaseResource):
    """
    Represents a request for a patient to employ a medical device. The device may be an implantable device, or an external assistive device, such as a walker.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["DeviceRequest"], FieldMetadata(alias="resourceType")
    ] = "DeviceRequest"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Identifiers assigned to this order by the orderer or by the receiver.
    """

    instantiates_canonical: typing_extensions.Annotated[
        typing.Optional[typing.List[Canonical]],
        FieldMetadata(alias="instantiatesCanonical"),
    ] = pydantic.Field(default=None)
    """
    The URL pointing to a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this DeviceRequest.
    """

    instantiates_uri: typing_extensions.Annotated[
        typing.Optional[typing.List[Uri]], FieldMetadata(alias="instantiatesUri")
    ] = pydantic.Field(default=None)
    """
    The URL pointing to an externally maintained protocol, guideline, orderset or other definition that is adhered to in whole or in part by this DeviceRequest.
    """

    based_on: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="basedOn")
    ] = pydantic.Field(default=None)
    """
    Plan/proposal/order fulfilled by this request.
    """

    prior_request: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="priorRequest")
    ] = pydantic.Field(default=None)
    """
    The request takes the place of the referenced completed or terminated request(s).
    """

    group_identifier: typing_extensions.Annotated[
        typing.Optional[Identifier], FieldMetadata(alias="groupIdentifier")
    ] = pydantic.Field(default=None)
    """
    Composite request this is part of.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The status of the request.
    """

    intent: typing.Optional[Code] = pydantic.Field(default=None)
    """
    Whether the request is a proposal, plan, an original order or a reflex order.
    """

    priority: typing.Optional[Code] = pydantic.Field(default=None)
    """
    Indicates how quickly the {{title}} should be addressed with respect to other requests.
    """

    code_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="codeReference")
    ] = pydantic.Field(default=None)
    """
    The details of the device to be used.
    """

    code_codeable_concept: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="codeCodeableConcept")
    ] = pydantic.Field(default=None)
    """
    The details of the device to be used.
    """

    parameter: typing.Optional[typing.List[DeviceRequestParameter]] = pydantic.Field(
        default=None
    )
    """
    Specific parameters for the ordered item. For example, the prism value for lenses.
    """

    subject: Reference = pydantic.Field()
    """
    The patient who will use the device.
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    An encounter that provides additional context in which this request is made.
    """

    occurrence_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="occurrenceDateTime")
    ] = pydantic.Field(default=None)
    """
    The timing schedule for the use of the device. The Schedule data type allows many different expressions, for example. "Every 8 hours"; "Three times a day"; "1/2 an hour before breakfast for 10 days from 23-Dec 2011:"; "15 Oct 2013, 17 Oct 2013 and 1 Nov 2013".
    """

    occurrence_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="occurrencePeriod")
    ] = pydantic.Field(default=None)
    """
    The timing schedule for the use of the device. The Schedule data type allows many different expressions, for example. "Every 8 hours"; "Three times a day"; "1/2 an hour before breakfast for 10 days from 23-Dec 2011:"; "15 Oct 2013, 17 Oct 2013 and 1 Nov 2013".
    """

    occurrence_timing: typing_extensions.Annotated[
        typing.Optional[Timing], FieldMetadata(alias="occurrenceTiming")
    ] = pydantic.Field(default=None)
    """
    The timing schedule for the use of the device. The Schedule data type allows many different expressions, for example. "Every 8 hours"; "Three times a day"; "1/2 an hour before breakfast for 10 days from 23-Dec 2011:"; "15 Oct 2013, 17 Oct 2013 and 1 Nov 2013".
    """

    authored_on: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="authoredOn")
    ] = pydantic.Field(default=None)
    """
    When the request transitioned to being actionable.
    """

    requester: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The individual who initiated the request and has responsibility for its activation.
    """

    performer_type: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="performerType")
    ] = pydantic.Field(default=None)
    """
    Desired type of performer for doing the diagnostic testing.
    """

    performer: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The desired performer for doing the diagnostic testing.
    """

    reason_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="reasonCode")
    ] = pydantic.Field(default=None)
    """
    Reason or justification for the use of this device.
    """

    reason_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="reasonReference")
    ] = pydantic.Field(default=None)
    """
    Reason or justification for the use of this device.
    """

    insurance: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Insurance plans, coverage extensions, pre-authorizations and/or pre-determinations that may be required for delivering the requested service.
    """

    supporting_info: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="supportingInfo")
    ] = pydantic.Field(default=None)
    """
    Additional clinical information about the patient that may influence the request fulfilment. For example, this may include where on the subject's body the device will be used (i.e. the target site).
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Details about this request that were not represented at all or sufficiently in one of the attributes provided in a class. These may include for example a comment, an instruction, or a note associated with the statement.
    """

    relevant_history: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="relevantHistory")
    ] = pydantic.Field(default=None)
    """
    Key events in the history of the request.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
