# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .device_metric_operational_status import DeviceMetricOperationalStatus
from .device_metric_color import DeviceMetricColor
from .device_metric_category import DeviceMetricCategory
from .device_metric_calibration import DeviceMetricCalibration
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class DeviceMetric(BaseResource):
    """
    Describes a measurement, calculation or setting capability of a medical device.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["DeviceMetric"], FieldMetadata(alias="resourceType")
    ] = "DeviceMetric"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Unique instance identifiers assigned to a device by the device or gateway software, manufacturers, other organizations or owners. For example: handle ID.
    """

    type: CodeableConcept = pydantic.Field()
    """
    Describes the type of the metric. For example: Heart Rate, PEEP Setting, etc.
    """

    unit: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Describes the unit that an observed value determined for this metric will have. For example: Percent, Seconds, etc.
    """

    source: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Describes the link to the Device that this DeviceMetric belongs to and that contains administrative device information such as manufacturer, serial number, etc.
    """

    parent: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Describes the link to the Device that this DeviceMetric belongs to and that provide information about the location of this DeviceMetric in the containment structure of the parent Device. An example would be a Device that represents a Channel. This reference can be used by a client application to distinguish DeviceMetrics that have the same type, but should be interpreted based on their containment location.
    """

    operational_status: typing_extensions.Annotated[
        typing.Optional[DeviceMetricOperationalStatus],
        FieldMetadata(alias="operationalStatus"),
    ] = pydantic.Field(default=None)
    """
    Indicates current operational state of the device. For example: On, Off, Standby, etc.
    """

    color: typing.Optional[DeviceMetricColor] = pydantic.Field(default=None)
    """
    Describes the color representation for the metric. This is often used to aid clinicians to track and identify parameter types by color. In practice, consider a Patient Monitor that has ECG/HR and Pleth for example; the parameters are displayed in different characteristic colors, such as HR-blue, BP-green, and PR and SpO2- magenta.
    """

    category: typing.Optional[DeviceMetricCategory] = pydantic.Field(default=None)
    """
    Indicates the category of the observation generation process. A DeviceMetric can be for example a setting, measurement, or calculation.
    """

    measurement_period: typing_extensions.Annotated[
        typing.Optional[Timing], FieldMetadata(alias="measurementPeriod")
    ] = pydantic.Field(default=None)
    """
    Describes the measurement repetition time. This is not necessarily the same as the update period. The measurement repetition time can range from milliseconds up to hours. An example for a measurement repetition time in the range of milliseconds is the sampling rate of an ECG. An example for a measurement repetition time in the range of hours is a NIBP that is triggered automatically every hour. The update period may be different than the measurement repetition time, if the device does not update the published observed value with the same frequency as it was measured.
    """

    calibration: typing.Optional[typing.List[DeviceMetricCalibration]] = pydantic.Field(
        default=None
    )
    """
    Describes the calibrations that have been performed or that are required to be performed.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
