# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .device_definition_udi_device_identifier import DeviceDefinitionUdiDeviceIdentifier
from .device_definition_device_name import DeviceDefinitionDeviceName
from .device_definition_specialization import DeviceDefinitionSpecialization
from .product_shelf_life import ProductShelfLife
from .prod_characteristic import ProdCharacteristic
from .device_definition_capability import DeviceDefinitionCapability
from .device_definition_property import DeviceDefinitionProperty
from .uri import Uri
from .device_definition_material import DeviceDefinitionMaterial
from .device_definition_classification import DeviceDefinitionClassification
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class DeviceDefinition(BaseResource):
    """
    The characteristics, operational status and capabilities of a medical-related component of a medical device.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["DeviceDefinition"], FieldMetadata(alias="resourceType")
    ] = "DeviceDefinition"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Unique instance identifiers assigned to a device by the software, manufacturers, other organizations or owners. For example: handle ID.
    """

    udi_device_identifier: typing_extensions.Annotated[
        typing.Optional[typing.List[DeviceDefinitionUdiDeviceIdentifier]],
        FieldMetadata(alias="udiDeviceIdentifier"),
    ] = pydantic.Field(default=None)
    """
    Unique device identifier (UDI) assigned to device label or package. Note that the Device may include multiple udiCarriers as it either may include just the udiCarrier for the jurisdiction it is sold, or for multiple jurisdictions it could have been sold.
    """

    manufacturer_string: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="manufacturerString")
    ] = pydantic.Field(default=None)
    """
    A name of the manufacturer.
    """

    manufacturer_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="manufacturerReference")
    ] = pydantic.Field(default=None)
    """
    A name of the manufacturer.
    """

    device_name: typing_extensions.Annotated[
        typing.Optional[typing.List[DeviceDefinitionDeviceName]],
        FieldMetadata(alias="deviceName"),
    ] = pydantic.Field(default=None)
    """
    A name given to the device to identify it.
    """

    model_number: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="modelNumber")
    ] = pydantic.Field(default=None)
    """
    The model number for the device.
    """

    type: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    What kind of device or device system this is.
    """

    specialization: typing.Optional[typing.List[DeviceDefinitionSpecialization]] = (
        pydantic.Field(default=None)
    )
    """
    The capabilities supported on a device, the standards to which the device conforms for a particular purpose, and used for the communication.
    """

    version: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The available versions of the device, e.g., software versions.
    """

    safety: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    Safety characteristics of the device.
    """

    shelf_life_storage: typing_extensions.Annotated[
        typing.Optional[typing.List[ProductShelfLife]],
        FieldMetadata(alias="shelfLifeStorage"),
    ] = pydantic.Field(default=None)
    """
    Shelf Life and storage information.
    """

    physical_characteristics: typing_extensions.Annotated[
        typing.Optional[ProdCharacteristic],
        FieldMetadata(alias="physicalCharacteristics"),
    ] = pydantic.Field(default=None)
    """
    Dimensions, color etc.
    """

    language_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="languageCode"),
    ] = pydantic.Field(default=None)
    """
    Language code for the human-readable text strings produced by the device (all supported).
    """

    capability: typing.Optional[typing.List[DeviceDefinitionCapability]] = (
        pydantic.Field(default=None)
    )
    """
    Device capabilities.
    """

    property: typing.Optional[typing.List[DeviceDefinitionProperty]] = pydantic.Field(
        default=None
    )
    """
    The actual configuration settings of a device as it actually operates, e.g., regulation status, time properties.
    """

    owner: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    An organization that is responsible for the provision and ongoing maintenance of the device.
    """

    contact: typing.Optional[typing.List[ContactPoint]] = pydantic.Field(default=None)
    """
    Contact details for an organization or a particular human that is responsible for the device.
    """

    url: typing.Optional[Uri] = pydantic.Field(default=None)
    """
    A network address on which the device may be contacted directly.
    """

    online_information: typing_extensions.Annotated[
        typing.Optional[Uri], FieldMetadata(alias="onlineInformation")
    ] = pydantic.Field(default=None)
    """
    Access to on-line information about the device.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Descriptive information, usage information or implantation information that is not captured in an existing element.
    """

    quantity: typing.Optional[Quantity] = pydantic.Field(default=None)
    """
    The quantity of the device present in the packaging (e.g. the number of devices present in a pack, or the number of devices in the same package of the medicinal product).
    """

    parent_device: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="parentDevice")
    ] = pydantic.Field(default=None)
    """
    The parent device it can be part of.
    """

    material: typing.Optional[typing.List[DeviceDefinitionMaterial]] = pydantic.Field(
        default=None
    )
    """
    A substance used to create the material(s) of which the device is made.
    """

    classification: typing.Optional[typing.List[DeviceDefinitionClassification]] = (
        pydantic.Field(default=None)
    )
    """
    What kind of device or device system this is.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
