# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .device_udi_carrier import DeviceUdiCarrier
from .device_status import DeviceStatus
from .date_time import DateTime
from .device_device_name import DeviceDeviceName
from .device_specialization import DeviceSpecialization
from .device_version import DeviceVersion
from .device_property import DeviceProperty
from .uri import Uri
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Device(BaseResource):
    """
    A type of a manufactured item that is used in the provision of healthcare without being substantially changed through that activity. The device may be a medical or non-medical device.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Device"], FieldMetadata(alias="resourceType")
    ] = "Device"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Unique instance identifiers assigned to a device by manufacturers other organizations or owners.
    """

    definition: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The reference to the definition for the device.
    """

    udi_carrier: typing_extensions.Annotated[
        typing.Optional[typing.List[DeviceUdiCarrier]],
        FieldMetadata(alias="udiCarrier"),
    ] = pydantic.Field(default=None)
    """
    Unique device identifier (UDI) assigned to device label or package. Note that the Device may include multiple udiCarriers as it either may include just the udiCarrier for the jurisdiction it is sold, or for multiple jurisdictions it could have been sold.
    """

    status: typing.Optional[DeviceStatus] = pydantic.Field(default=None)
    """
    Status of the Device availability.
    """

    status_reason: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="statusReason"),
    ] = pydantic.Field(default=None)
    """
    Reason for the dtatus of the Device availability.
    """

    distinct_identifier: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="distinctIdentifier")
    ] = pydantic.Field(default=None)
    """
    The distinct identification string as required by regulation for a human cell, tissue, or cellular and tissue-based product.
    """

    manufacturer: typing.Optional[str] = pydantic.Field(default=None)
    """
    A name of the manufacturer.
    """

    manufacture_date: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="manufactureDate")
    ] = pydantic.Field(default=None)
    """
    The date and time when the device was manufactured.
    """

    expiration_date: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="expirationDate")
    ] = pydantic.Field(default=None)
    """
    The date and time beyond which this device is no longer valid or should not be used (if applicable).
    """

    lot_number: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="lotNumber")
    ] = pydantic.Field(default=None)
    """
    Lot number assigned by the manufacturer.
    """

    serial_number: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="serialNumber")
    ] = pydantic.Field(default=None)
    """
    The serial number assigned by the organization when the device was manufactured.
    """

    device_name: typing_extensions.Annotated[
        typing.Optional[typing.List[DeviceDeviceName]],
        FieldMetadata(alias="deviceName"),
    ] = pydantic.Field(default=None)
    """
    This represents the manufacturer's name of the device as provided by the device, from a UDI label, or by a person describing the Device. This typically would be used when a person provides the name(s) or when the device represents one of the names available from DeviceDefinition.
    """

    model_number: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="modelNumber")
    ] = pydantic.Field(default=None)
    """
    The model number for the device.
    """

    part_number: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="partNumber")
    ] = pydantic.Field(default=None)
    """
    The part number of the device.
    """

    type: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The kind or type of device.
    """

    specialization: typing.Optional[typing.List[DeviceSpecialization]] = pydantic.Field(
        default=None
    )
    """
    The capabilities supported on a device, the standards to which the device conforms for a particular purpose, and used for the communication.
    """

    version: typing.Optional[typing.List[DeviceVersion]] = pydantic.Field(default=None)
    """
    The actual design of the device or software version running on the device.
    """

    property: typing.Optional[typing.List[DeviceProperty]] = pydantic.Field(
        default=None
    )
    """
    The actual configuration settings of a device as it actually operates, e.g., regulation status, time properties.
    """

    patient: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Patient information, If the device is affixed to a person.
    """

    owner: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    An organization that is responsible for the provision and ongoing maintenance of the device.
    """

    contact: typing.Optional[typing.List[ContactPoint]] = pydantic.Field(default=None)
    """
    Contact details for an organization or a particular human that is responsible for the device.
    """

    location: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The place where the device can be found.
    """

    url: typing.Optional[Uri] = pydantic.Field(default=None)
    """
    A network address on which the device may be contacted directly.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Descriptive information, usage information or implantation information that is not captured in an existing element.
    """

    safety: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    Provides additional safety characteristics about a medical device. For example devices containing latex.
    """

    parent: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The parent device.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
