# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .code import Code
from .detected_issue_severity import DetectedIssueSeverity
from .detected_issue_evidence import DetectedIssueEvidence
from .uri import Uri
from .detected_issue_mitigation import DetectedIssueMitigation
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class DetectedIssue(BaseResource):
    """
    Indicates an actual or potential clinical issue with or between one or more active or proposed clinical actions for a patient; e.g. Drug-drug interaction, Ineffective treatment frequency, Procedure-condition conflict, etc.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["DetectedIssue"], FieldMetadata(alias="resourceType")
    ] = "DetectedIssue"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Business identifier associated with the detected issue record.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    Indicates the status of the detected issue.
    """

    code: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Identifies the general type of issue identified.
    """

    severity: typing.Optional[DetectedIssueSeverity] = pydantic.Field(default=None)
    """
    Indicates the degree of importance associated with the identified issue based on the potential impact on the patient.
    """

    patient: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Indicates the patient whose record the detected issue is associated with.
    """

    identified_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="identifiedDateTime")
    ] = pydantic.Field(default=None)
    """
    The date or period when the detected issue was initially identified.
    """

    identified_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="identifiedPeriod")
    ] = pydantic.Field(default=None)
    """
    The date or period when the detected issue was initially identified.
    """

    author: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Individual or device responsible for the issue being raised. For example, a decision support application or a pharmacist conducting a medication review.
    """

    implicated: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Indicates the resource representing the current activity or proposed activity that is potentially problematic.
    """

    evidence: typing.Optional[typing.List[DetectedIssueEvidence]] = pydantic.Field(
        default=None
    )
    """
    Supporting evidence or manifestations that provide the basis for identifying the detected issue such as a GuidanceResponse or MeasureReport.
    """

    detail: typing.Optional[str] = pydantic.Field(default=None)
    """
    A textual explanation of the detected issue.
    """

    reference: typing.Optional[Uri] = pydantic.Field(default=None)
    """
    The literature, knowledge-base or similar reference that describes the propensity for the detected issue identified.
    """

    mitigation: typing.Optional[typing.List[DetectedIssueMitigation]] = pydantic.Field(
        default=None
    )
    """
    Indicates an action that has been taken or is committed to reduce or eliminate the likelihood of the risk identified by the detected issue from manifesting. Can also reflect an observation of known mitigating factors that may reduce/eliminate the need for any action.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
