# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ...core.pydantic_utilities import UniversalBaseModel
import typing
import pydantic
from .code import Code
from .canonical import Canonical
import typing_extensions
from ...core.serialization import FieldMetadata
from .positive_int import PositiveInt
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.pydantic_utilities import update_forward_refs


class DataRequirement(UniversalBaseModel):
    """
    Describes a required data item for evaluation in terms of the type of data, and optional code or date-based filters of the data.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List["Extension"]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    type: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The type of the required data, specified as the type name of a resource. For profiles, this value is set to the type of the base resource of the profile.
    """

    profile: typing.Optional[typing.List[Canonical]] = pydantic.Field(default=None)
    """
    The profile of the required data, specified as the uri of the profile definition.
    """

    subject_codeable_concept: typing_extensions.Annotated[
        typing.Optional["CodeableConcept"],
        FieldMetadata(alias="subjectCodeableConcept"),
    ] = pydantic.Field(default=None)
    """
    The intended subjects of the data requirement. If this element is not provided, a Patient subject is assumed.
    """

    subject_reference: typing_extensions.Annotated[
        typing.Optional["Reference"], FieldMetadata(alias="subjectReference")
    ] = pydantic.Field(default=None)
    """
    The intended subjects of the data requirement. If this element is not provided, a Patient subject is assumed.
    """

    must_support: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="mustSupport")
    ] = pydantic.Field(default=None)
    """
    Indicates that specific elements of the type are referenced by the knowledge module and must be supported by the consumer in order to obtain an effective evaluation. This does not mean that a value is required for this element, only that the consuming system must understand the element and be able to provide values for it if they are available. The value of mustSupport SHALL be a FHIRPath resolveable on the type of the DataRequirement. The path SHALL consist only of identifiers, constant indexers, and .resolve() (see the [Simple FHIRPath Profile](fhirpath.html#simple) for full details).
    """

    code_filter: typing_extensions.Annotated[
        typing.Optional[typing.List["DataRequirementCodeFilter"]],
        FieldMetadata(alias="codeFilter"),
    ] = pydantic.Field(default=None)
    """
    Code filters specify additional constraints on the data, specifying the value set of interest for a particular element of the data. Each code filter defines an additional constraint on the data, i.e. code filters are AND'ed, not OR'ed.
    """

    date_filter: typing_extensions.Annotated[
        typing.Optional[typing.List["DataRequirementDateFilter"]],
        FieldMetadata(alias="dateFilter"),
    ] = pydantic.Field(default=None)
    """
    Date filters specify additional constraints on the data in terms of the applicable date range for specific elements. Each date filter specifies an additional constraint on the data, i.e. date filters are AND'ed, not OR'ed.
    """

    limit: typing.Optional[PositiveInt] = pydantic.Field(default=None)
    """
    Specifies a maximum number of results that are required (uses the \_count search parameter).
    """

    sort: typing.Optional[typing.List["DataRequirementSort"]] = pydantic.Field(
        default=None
    )
    """
    Specifies the order of the results to be returned.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .address import Address  # noqa: E402
from .age import Age  # noqa: E402
from .annotation import Annotation  # noqa: E402
from .attachment import Attachment  # noqa: E402
from .codeable_concept import CodeableConcept  # noqa: E402
from .coding import Coding  # noqa: E402
from .contact_detail import ContactDetail  # noqa: E402
from .contact_point import ContactPoint  # noqa: E402
from .contributor import Contributor  # noqa: E402
from .count import Count  # noqa: E402
from .data_requirement_code_filter import DataRequirementCodeFilter  # noqa: E402
from .data_requirement_date_filter import DataRequirementDateFilter  # noqa: E402
from .data_requirement_sort import DataRequirementSort  # noqa: E402
from .distance import Distance  # noqa: E402
from .dosage import Dosage  # noqa: E402
from .dosage_dose_and_rate import DosageDoseAndRate  # noqa: E402
from .duration import Duration  # noqa: E402
from .expression import Expression  # noqa: E402
from .extension import Extension  # noqa: E402
from .human_name import HumanName  # noqa: E402
from .identifier import Identifier  # noqa: E402
from .meta import Meta  # noqa: E402
from .money import Money  # noqa: E402
from .parameter_definition import ParameterDefinition  # noqa: E402
from .period import Period  # noqa: E402
from .quantity import Quantity  # noqa: E402
from .range import Range  # noqa: E402
from .ratio import Ratio  # noqa: E402
from .reference import Reference  # noqa: E402
from .related_artifact import RelatedArtifact  # noqa: E402
from .sampled_data import SampledData  # noqa: E402
from .signature import Signature  # noqa: E402
from .timing import Timing  # noqa: E402
from .timing_repeat import TimingRepeat  # noqa: E402
from .trigger_definition import TriggerDefinition  # noqa: E402
from .usage_context import UsageContext  # noqa: E402

update_forward_refs(DataRequirement)
