# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .code import Code
from .coverage_eligibility_response_purpose_item import (
    CoverageEligibilityResponsePurposeItem,
)
from .date_time import DateTime
from .coverage_eligibility_response_outcome import CoverageEligibilityResponseOutcome
from .coverage_eligibility_response_insurance import (
    CoverageEligibilityResponseInsurance,
)
from .coverage_eligibility_response_error import CoverageEligibilityResponseError
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CoverageEligibilityResponse(BaseResource):
    """
    This resource provides eligibility and plan details from the processing of an CoverageEligibilityRequest resource.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["CoverageEligibilityResponse"],
        FieldMetadata(alias="resourceType"),
    ] = "CoverageEligibilityResponse"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    A unique identifier assigned to this coverage eligiblity request.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The status of the resource instance.
    """

    purpose: typing.Optional[typing.List[CoverageEligibilityResponsePurposeItem]] = (
        pydantic.Field(default=None)
    )
    """
    Code to specify whether requesting: prior authorization requirements for some service categories or billing codes; benefits for coverages specified or discovered; discovery and return of coverages for the patient; and/or validation that the specified coverage is in-force at the date/period specified or 'now' if not specified.
    """

    patient: Reference = pydantic.Field()
    """
    The party who is the beneficiary of the supplied coverage and for whom eligibility is sought.
    """

    serviced_date: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="servicedDate")
    ] = pydantic.Field(default=None)
    """
    The date or dates when the enclosed suite of services were performed or completed.
    """

    serviced_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="servicedPeriod")
    ] = pydantic.Field(default=None)
    """
    The date or dates when the enclosed suite of services were performed or completed.
    """

    created: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date this resource was created.
    """

    requestor: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The provider which is responsible for the request.
    """

    request: Reference = pydantic.Field()
    """
    Reference to the original request resource.
    """

    outcome: typing.Optional[CoverageEligibilityResponseOutcome] = pydantic.Field(
        default=None
    )
    """
    The outcome of the request processing.
    """

    disposition: typing.Optional[str] = pydantic.Field(default=None)
    """
    A human readable description of the status of the adjudication.
    """

    insurer: Reference = pydantic.Field()
    """
    The Insurer who issued the coverage in question and is the author of the response.
    """

    insurance: typing.Optional[typing.List[CoverageEligibilityResponseInsurance]] = (
        pydantic.Field(default=None)
    )
    """
    Financial instruments for reimbursement for the health care products and services.
    """

    pre_auth_ref: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="preAuthRef")
    ] = pydantic.Field(default=None)
    """
    A reference from the Insurer to which these services pertain to be used on further communication and as proof that the request occurred.
    """

    form: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    A code for the form to be used for printing the content.
    """

    error: typing.Optional[typing.List[CoverageEligibilityResponseError]] = (
        pydantic.Field(default=None)
    )
    """
    Errors encountered during the processing of the request.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
