# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .positive_int import PositiveInt
from .coverage_eligibility_request_diagnosis import CoverageEligibilityRequestDiagnosis
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CoverageEligibilityRequestItem(UniversalBaseModel):
    """
    The CoverageEligibilityRequest provides patient and insurance coverage information to an insurer for them to respond, in the form of an CoverageEligibilityResponse, with information regarding whether the stated coverage is valid and in-force and optionally to provide the insurance details of the policy.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    supporting_info_sequence: typing_extensions.Annotated[
        typing.Optional[typing.List[PositiveInt]],
        FieldMetadata(alias="supportingInfoSequence"),
    ] = pydantic.Field(default=None)
    """
    Exceptions, special conditions and supporting information applicable for this service or product line.
    """

    category: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Code to identify the general type of benefits under which products and services are provided.
    """

    product_or_service: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="productOrService")
    ] = pydantic.Field(default=None)
    """
    This contains the product, service, drug or other billing code for the item.
    """

    modifier: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    Item typification or modifiers codes to convey additional context for the product or service.
    """

    provider: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The practitioner who is responsible for the product or service to be rendered to the patient.
    """

    quantity: typing.Optional[Quantity] = pydantic.Field(default=None)
    """
    The number of repetitions of a service or product.
    """

    unit_price: typing_extensions.Annotated[
        typing.Optional[Money], FieldMetadata(alias="unitPrice")
    ] = pydantic.Field(default=None)
    """
    The amount charged to the patient by the provider for a single unit.
    """

    facility: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Facility where the services will be provided.
    """

    diagnosis: typing.Optional[typing.List[CoverageEligibilityRequestDiagnosis]] = (
        pydantic.Field(default=None)
    )
    """
    Patient diagnosis for which care is sought.
    """

    detail: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The plan/proposal/order describing the proposed service in detail.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
