# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .code import Code
from .coverage_eligibility_request_purpose_item import (
    CoverageEligibilityRequestPurposeItem,
)
from .date_time import DateTime
from .coverage_eligibility_request_supporting_info import (
    CoverageEligibilityRequestSupportingInfo,
)
from .coverage_eligibility_request_insurance import CoverageEligibilityRequestInsurance
from .coverage_eligibility_request_item import CoverageEligibilityRequestItem
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CoverageEligibilityRequest(BaseResource):
    """
    The CoverageEligibilityRequest provides patient and insurance coverage information to an insurer for them to respond, in the form of an CoverageEligibilityResponse, with information regarding whether the stated coverage is valid and in-force and optionally to provide the insurance details of the policy.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["CoverageEligibilityRequest"],
        FieldMetadata(alias="resourceType"),
    ] = "CoverageEligibilityRequest"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    A unique identifier assigned to this coverage eligiblity request.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The status of the resource instance.
    """

    priority: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    When the requestor expects the processor to complete processing.
    """

    purpose: typing.Optional[typing.List[CoverageEligibilityRequestPurposeItem]] = (
        pydantic.Field(default=None)
    )
    """
    Code to specify whether requesting: prior authorization requirements for some service categories or billing codes; benefits for coverages specified or discovered; discovery and return of coverages for the patient; and/or validation that the specified coverage is in-force at the date/period specified or 'now' if not specified.
    """

    patient: Reference = pydantic.Field()
    """
    The party who is the beneficiary of the supplied coverage and for whom eligibility is sought.
    """

    serviced_date: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="servicedDate")
    ] = pydantic.Field(default=None)
    """
    The date or dates when the enclosed suite of services were performed or completed.
    """

    serviced_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="servicedPeriod")
    ] = pydantic.Field(default=None)
    """
    The date or dates when the enclosed suite of services were performed or completed.
    """

    created: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date when this resource was created.
    """

    enterer: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Person who created the request.
    """

    provider: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The provider which is responsible for the request.
    """

    insurer: Reference = pydantic.Field()
    """
    The Insurer who issued the coverage in question and is the recipient of the request.
    """

    facility: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Facility where the services are intended to be provided.
    """

    supporting_info: typing_extensions.Annotated[
        typing.Optional[typing.List[CoverageEligibilityRequestSupportingInfo]],
        FieldMetadata(alias="supportingInfo"),
    ] = pydantic.Field(default=None)
    """
    Additional information codes regarding exceptions, special considerations, the condition, situation, prior or concurrent issues.
    """

    insurance: typing.Optional[typing.List[CoverageEligibilityRequestInsurance]] = (
        pydantic.Field(default=None)
    )
    """
    Financial instruments for reimbursement for the health care products and services.
    """

    item: typing.Optional[typing.List[CoverageEligibilityRequestItem]] = pydantic.Field(
        default=None
    )
    """
    Service categories or billable services for which benefit details and/or an authorization prior to service delivery may be required by the payor.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
