# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .code import Code
from .coverage_class import CoverageClass
from .positive_int import PositiveInt
from .coverage_cost_to_beneficiary import CoverageCostToBeneficiary
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Coverage(BaseResource):
    """
    Financial instrument which may be used to reimburse or pay for health care products and services. Includes both insurance and self-payment.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Coverage"], FieldMetadata(alias="resourceType")
    ] = "Coverage"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    A unique identifier assigned to this coverage.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The status of the resource instance.
    """

    type: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The type of coverage: social program, medical plan, accident coverage (workers compensation, auto), group health or payment by an individual or organization.
    """

    policy_holder: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="policyHolder")
    ] = pydantic.Field(default=None)
    """
    The party who 'owns' the insurance policy.
    """

    subscriber: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The party who has signed-up for or 'owns' the contractual relationship to the policy or to whom the benefit of the policy for services rendered to them or their family is due.
    """

    subscriber_id: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="subscriberId")
    ] = pydantic.Field(default=None)
    """
    The insurer assigned ID for the Subscriber.
    """

    beneficiary: Reference = pydantic.Field()
    """
    The party who benefits from the insurance coverage; the patient when products and/or services are provided.
    """

    dependent: typing.Optional[str] = pydantic.Field(default=None)
    """
    A unique identifier for a dependent under the coverage.
    """

    relationship: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The relationship of beneficiary (patient) to the subscriber.
    """

    period: typing.Optional[Period] = pydantic.Field(default=None)
    """
    Time period during which the coverage is in force. A missing start date indicates the start date isn't known, a missing end date means the coverage is continuing to be in force.
    """

    payor: typing.List[Reference] = pydantic.Field()
    """
    The program or plan underwriter or payor including both insurance and non-insurance agreements, such as patient-pay agreements.
    """

    class_: typing_extensions.Annotated[
        typing.Optional[typing.List[CoverageClass]], FieldMetadata(alias="class")
    ] = pydantic.Field(default=None)
    """
    A suite of underwriter specific classifiers.
    """

    order: typing.Optional[PositiveInt] = pydantic.Field(default=None)
    """
    The order of applicability of this coverage relative to other coverages which are currently in force. Note, there may be gaps in the numbering and this does not imply primary, secondary etc. as the specific positioning of coverages depends upon the episode of care.
    """

    network: typing.Optional[str] = pydantic.Field(default=None)
    """
    The insurer-specific identifier for the insurer-defined network of providers to which the beneficiary may seek treatment which will be covered at the 'in-network' rate, otherwise 'out of network' terms and conditions apply.
    """

    cost_to_beneficiary: typing_extensions.Annotated[
        typing.Optional[typing.List[CoverageCostToBeneficiary]],
        FieldMetadata(alias="costToBeneficiary"),
    ] = pydantic.Field(default=None)
    """
    A suite of codes indicating the cost category and associated amount which have been detailed in the policy and may have been included on the health card.
    """

    subrogation: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When 'subrogation=true' this insurance instance has been included not for adjudication but to provide insurers with the details to recover costs.
    """

    contract: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The policy(s) which constitute this insurance coverage.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
