# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .contract_party import ContractParty
from .contract_answer import ContractAnswer
from .unsigned_int import UnsignedInt
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ContractOffer(UniversalBaseModel):
    """
    Legally enforceable, formally recorded unilateral or bilateral directive i.e., a policy or agreement.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Unique identifier for this particular Contract Provision.
    """

    party: typing.Optional[typing.List[ContractParty]] = pydantic.Field(default=None)
    """
    Offer Recipient.
    """

    topic: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The owner of an asset has the residual control rights over the asset: the right to decide all usages of the asset in any way not inconsistent with a prior contract, custom, or law (Hart, 1995, p. 30).
    """

    type: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Type of Contract Provision such as specific requirements, purposes for actions, obligations, prohibitions, e.g. life time maximum benefit.
    """

    decision: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Type of choice made by accepting party with respect to an offer made by an offeror/ grantee.
    """

    decision_mode: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="decisionMode"),
    ] = pydantic.Field(default=None)
    """
    How the decision about a Contract was conveyed.
    """

    answer: typing.Optional[typing.List[ContractAnswer]] = pydantic.Field(default=None)
    """
    Response to offer text.
    """

    text: typing.Optional[str] = pydantic.Field(default=None)
    """
    Human readable form of this Contract Offer.
    """

    link_id: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="linkId")
    ] = pydantic.Field(default=None)
    """
    The id of the clause or question text of the offer in the referenced questionnaire/response.
    """

    security_label_number: typing_extensions.Annotated[
        typing.Optional[typing.List[UnsignedInt]],
        FieldMetadata(alias="securityLabelNumber"),
    ] = pydantic.Field(default=None)
    """
    Security labels that protects the offer.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
