# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .contract_context import ContractContext
from .contract_answer import ContractAnswer
from .unsigned_int import UnsignedInt
from .contract_valued_item import ContractValuedItem
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ContractAsset(UniversalBaseModel):
    """
    Legally enforceable, formally recorded unilateral or bilateral directive i.e., a policy or agreement.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    scope: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Differentiates the kind of the asset .
    """

    type: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    Target entity type about which the term may be concerned.
    """

    type_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="typeReference")
    ] = pydantic.Field(default=None)
    """
    Associated entities.
    """

    subtype: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    May be a subtype or part of an offered asset.
    """

    relationship: typing.Optional[Coding] = pydantic.Field(default=None)
    """
    Specifies the applicability of the term to an asset resource instance, and instances it refers to orinstances that refer to it, and/or are owned by the offeree.
    """

    context: typing.Optional[typing.List[ContractContext]] = pydantic.Field(
        default=None
    )
    """
    Circumstance of the asset.
    """

    condition: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the quality and completeness of the asset that imay be a factor in its valuation.
    """

    period_type: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="periodType")
    ] = pydantic.Field(default=None)
    """
    Type of Asset availability for use or ownership.
    """

    period: typing.Optional[typing.List[Period]] = pydantic.Field(default=None)
    """
    Asset relevant contractual time period.
    """

    use_period: typing_extensions.Annotated[
        typing.Optional[typing.List[Period]], FieldMetadata(alias="usePeriod")
    ] = pydantic.Field(default=None)
    """
    Time period of asset use.
    """

    text: typing.Optional[str] = pydantic.Field(default=None)
    """
    Clause or question text (Prose Object) concerning the asset in a linked form, such as a QuestionnaireResponse used in the formation of the contract.
    """

    link_id: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="linkId")
    ] = pydantic.Field(default=None)
    """
    Id [identifier??] of the clause or question text about the asset in the referenced form or QuestionnaireResponse.
    """

    answer: typing.Optional[typing.List[ContractAnswer]] = pydantic.Field(default=None)
    """
    Response to assets.
    """

    security_label_number: typing_extensions.Annotated[
        typing.Optional[typing.List[UnsignedInt]],
        FieldMetadata(alias="securityLabelNumber"),
    ] = pydantic.Field(default=None)
    """
    Security labels that protects the asset.
    """

    valued_item: typing_extensions.Annotated[
        typing.Optional[typing.List[ContractValuedItem]],
        FieldMetadata(alias="valuedItem"),
    ] = pydantic.Field(default=None)
    """
    Contract Valued Item List.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
