# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .contract_subject import ContractSubject
from .unsigned_int import UnsignedInt
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ContractAction(UniversalBaseModel):
    """
    Legally enforceable, formally recorded unilateral or bilateral directive i.e., a policy or agreement.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    do_not_perform: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="doNotPerform")
    ] = pydantic.Field(default=None)
    """
    True if the term prohibits the action.
    """

    type: CodeableConcept = pydantic.Field()
    """
    Activity or service obligation to be done or not done, performed or not performed, effectuated or not by this Contract term.
    """

    subject: typing.Optional[typing.List[ContractSubject]] = pydantic.Field(
        default=None
    )
    """
    Entity of the action.
    """

    intent: CodeableConcept = pydantic.Field()
    """
    Reason or purpose for the action stipulated by this Contract Provision.
    """

    link_id: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="linkId")
    ] = pydantic.Field(default=None)
    """
    Id [identifier??] of the clause or question text related to this action in the referenced form or QuestionnaireResponse.
    """

    status: CodeableConcept = pydantic.Field()
    """
    Current state of the term action.
    """

    context: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Encounter or Episode with primary association to specified term activity.
    """

    context_link_id: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="contextLinkId")
    ] = pydantic.Field(default=None)
    """
    Id [identifier??] of the clause or question text related to the requester of this action in the referenced form or QuestionnaireResponse.
    """

    occurrence_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="occurrenceDateTime")
    ] = pydantic.Field(default=None)
    """
    When action happens.
    """

    occurrence_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="occurrencePeriod")
    ] = pydantic.Field(default=None)
    """
    When action happens.
    """

    occurrence_timing: typing_extensions.Annotated[
        typing.Optional[Timing], FieldMetadata(alias="occurrenceTiming")
    ] = pydantic.Field(default=None)
    """
    When action happens.
    """

    requester: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Who or what initiated the action and has responsibility for its activation.
    """

    requester_link_id: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="requesterLinkId")
    ] = pydantic.Field(default=None)
    """
    Id [identifier??] of the clause or question text related to the requester of this action in the referenced form or QuestionnaireResponse.
    """

    performer_type: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="performerType"),
    ] = pydantic.Field(default=None)
    """
    The type of individual that is desired or required to perform or not perform the action.
    """

    performer_role: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="performerRole")
    ] = pydantic.Field(default=None)
    """
    The type of role or competency of an individual desired or required to perform or not perform the action.
    """

    performer: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Indicates who or what is being asked to perform (or not perform) the ction.
    """

    performer_link_id: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="performerLinkId")
    ] = pydantic.Field(default=None)
    """
    Id [identifier??] of the clause or question text related to the reason type or reference of this action in the referenced form or QuestionnaireResponse.
    """

    reason_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="reasonCode")
    ] = pydantic.Field(default=None)
    """
    Rationale for the action to be performed or not performed. Describes why the action is permitted or prohibited.
    """

    reason_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="reasonReference")
    ] = pydantic.Field(default=None)
    """
    Indicates another resource whose existence justifies permitting or not permitting this action.
    """

    reason: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Describes why the action is to be performed or not performed in textual form.
    """

    reason_link_id: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="reasonLinkId")
    ] = pydantic.Field(default=None)
    """
    Id [identifier??] of the clause or question text related to the reason type or reference of this action in the referenced form or QuestionnaireResponse.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Comments made about the term action made by the requester, performer, subject or other participants.
    """

    security_label_number: typing_extensions.Annotated[
        typing.Optional[typing.List[UnsignedInt]],
        FieldMetadata(alias="securityLabelNumber"),
    ] = pydantic.Field(default=None)
    """
    Security labels that protects the action.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
