# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
from .contract_term import ContractTerm
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .uri import Uri
from .code import Code
from .date_time import DateTime
from .contract_content_definition import ContractContentDefinition
from .contract_signer import ContractSigner
from .contract_friendly import ContractFriendly
from .contract_legal import ContractLegal
from .contract_rule import ContractRule
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Contract(BaseResource):
    """
    Legally enforceable, formally recorded unilateral or bilateral directive i.e., a policy or agreement.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Contract"], FieldMetadata(alias="resourceType")
    ] = "Contract"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Unique identifier for this Contract or a derivative that references a Source Contract.
    """

    url: typing.Optional[Uri] = pydantic.Field(default=None)
    """
    Canonical identifier for this contract, represented as a URI (globally unique).
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    An edition identifier used for business purposes to label business significant variants.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The status of the resource instance.
    """

    legal_state: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="legalState")
    ] = pydantic.Field(default=None)
    """
    Legal states of the formation of a legal instrument, which is a formally executed written document that can be formally attributed to its author, records and formally expresses a legally enforceable act, process, or contractual duty, obligation, or right, and therefore evidences that act, process, or agreement.
    """

    instantiates_canonical: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="instantiatesCanonical")
    ] = pydantic.Field(default=None)
    """
    The URL pointing to a FHIR-defined Contract Definition that is adhered to in whole or part by this Contract.
    """

    instantiates_uri: typing_extensions.Annotated[
        typing.Optional[Uri], FieldMetadata(alias="instantiatesUri")
    ] = pydantic.Field(default=None)
    """
    The URL pointing to an externally maintained definition that is adhered to in whole or in part by this Contract.
    """

    content_derivative: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="contentDerivative")
    ] = pydantic.Field(default=None)
    """
    The minimal content derived from the basal information source at a specific stage in its lifecycle.
    """

    issued: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    When this Contract was issued.
    """

    applies: typing.Optional[Period] = pydantic.Field(default=None)
    """
    Relevant time or time-period when this Contract is applicable.
    """

    expiration_type: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="expirationType")
    ] = pydantic.Field(default=None)
    """
    Event resulting in discontinuation or termination of this Contract instance by one or more parties to the contract.
    """

    subject: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The target entity impacted by or of interest to parties to the agreement.
    """

    authority: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    A formally or informally recognized grouping of people, principals, organizations, or jurisdictions formed for the purpose of achieving some form of collective action such as the promulgation, administration and enforcement of contracts and policies.
    """

    domain: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Recognized governance framework or system operating with a circumscribed scope in accordance with specified principles, policies, processes or procedures for managing rights, actions, or behaviors of parties or principals relative to resources.
    """

    site: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Sites in which the contract is complied with, exercised, or in force.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A natural language name identifying this Contract definition, derivative, or instance in any legal state. Provides additional information about its content. This name should be usable as an identifier for the module by machine processing applications such as code generation.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    A short, descriptive, user-friendly title for this Contract definition, derivative, or instance in any legal state.t giving additional information about its content.
    """

    subtitle: typing.Optional[str] = pydantic.Field(default=None)
    """
    An explanatory or alternate user-friendly title for this Contract definition, derivative, or instance in any legal state.t giving additional information about its content.
    """

    alias: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Alternative representation of the title for this Contract definition, derivative, or instance in any legal state., e.g., a domain specific contract number related to legislation.
    """

    author: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The individual or organization that authored the Contract definition, derivative, or instance in any legal state.
    """

    scope: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    A selector of legal concerns for this Contract definition, derivative, or instance in any legal state.
    """

    topic_codeable_concept: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="topicCodeableConcept")
    ] = pydantic.Field(default=None)
    """
    Narrows the range of legal concerns to focus on the achievement of specific contractual objectives.
    """

    topic_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="topicReference")
    ] = pydantic.Field(default=None)
    """
    Narrows the range of legal concerns to focus on the achievement of specific contractual objectives.
    """

    type: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    A high-level category for the legal instrument, whether constructed as a Contract definition, derivative, or instance in any legal state. Provides additional information about its content within the context of the Contract's scope to distinguish the kinds of systems that would be interested in the contract.
    """

    sub_type: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="subType")
    ] = pydantic.Field(default=None)
    """
    Sub-category for the Contract that distinguishes the kinds of systems that would be interested in the Contract within the context of the Contract's scope.
    """

    content_definition: typing_extensions.Annotated[
        typing.Optional[ContractContentDefinition],
        FieldMetadata(alias="contentDefinition"),
    ] = pydantic.Field(default=None)
    """
    Precusory content developed with a focus and intent of supporting the formation a Contract instance, which may be associated with and transformable into a Contract.
    """

    term: typing.Optional[typing.List[ContractTerm]] = pydantic.Field(default=None)
    """
    One or more Contract Provisions, which may be related and conveyed as a group, and may contain nested groups.
    """

    supporting_info: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="supportingInfo")
    ] = pydantic.Field(default=None)
    """
    Information that may be needed by/relevant to the performer in their execution of this term action.
    """

    relevant_history: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="relevantHistory")
    ] = pydantic.Field(default=None)
    """
    Links to Provenance records for past versions of this Contract definition, derivative, or instance, which identify key state transitions or updates that are likely to be relevant to a user looking at the current version of the Contract. The Provence.entity indicates the target that was changed in the update. http://build.fhir.org/provenance-definitions.html#Provenance.entity.
    """

    signer: typing.Optional[typing.List[ContractSigner]] = pydantic.Field(default=None)
    """
    Parties with legal standing in the Contract, including the principal parties, the grantor(s) and grantee(s), which are any person or organization bound by the contract, and any ancillary parties, which facilitate the execution of the contract such as a notary or witness.
    """

    friendly: typing.Optional[typing.List[ContractFriendly]] = pydantic.Field(
        default=None
    )
    """
    The "patient friendly language" versionof the Contract in whole or in parts. "Patient friendly language" means the representation of the Contract and Contract Provisions in a manner that is readily accessible and understandable by a layperson in accordance with best practices for communication styles that ensure that those agreeing to or signing the Contract understand the roles, actions, obligations, responsibilities, and implication of the agreement.
    """

    legal: typing.Optional[typing.List[ContractLegal]] = pydantic.Field(default=None)
    """
    List of Legal expressions or representations of this Contract.
    """

    rule: typing.Optional[typing.List[ContractRule]] = pydantic.Field(default=None)
    """
    List of Computable Policy Rule Language Representations of this Contract.
    """

    legally_binding_attachment: typing_extensions.Annotated[
        typing.Optional[Attachment], FieldMetadata(alias="legallyBindingAttachment")
    ] = pydantic.Field(default=None)
    """
    Legally binding Contract: This is the signed and legally recognized representation of the Contract, which is considered the "source of truth" and which would be the basis for legal action related to enforcement of this Contract.
    """

    legally_binding_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="legallyBindingReference")
    ] = pydantic.Field(default=None)
    """
    Legally binding Contract: This is the signed and legally recognized representation of the Contract, which is considered the "source of truth" and which would be the basis for legal action related to enforcement of this Contract.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
