# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
from .consent_provision import ConsentProvision
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .consent_status import ConsentStatus
from .date_time import DateTime
from .consent_policy import ConsentPolicy
from .consent_verification import ConsentVerification
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Consent(BaseResource):
    """
    A record of a healthcare consumer’s choices, which permits or denies identified recipient(s) or recipient role(s) to perform one or more actions within a given policy context, for specific purposes and periods of time.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Consent"], FieldMetadata(alias="resourceType")
    ] = "Consent"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Unique identifier for this copy of the Consent Statement.
    """

    status: typing.Optional[ConsentStatus] = pydantic.Field(default=None)
    """
    Indicates the current state of this consent.
    """

    scope: CodeableConcept = pydantic.Field()
    """
    A selector of the type of consent being presented: ADR, Privacy, Treatment, Research. This list is now extensible.
    """

    category: typing.List[CodeableConcept] = pydantic.Field()
    """
    A classification of the type of consents found in the statement. This element supports indexing and retrieval of consent statements.
    """

    patient: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The patient/healthcare consumer to whom this consent applies.
    """

    date_time: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="dateTime")
    ] = pydantic.Field(default=None)
    """
    When this Consent was issued / created / indexed.
    """

    performer: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Either the Grantor, which is the entity responsible for granting the rights listed in a Consent Directive or the Grantee, which is the entity responsible for complying with the Consent Directive, including any obligations or limitations on authorizations and enforcement of prohibitions.
    """

    organization: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The organization that manages the consent, and the framework within which it is executed.
    """

    source_attachment: typing_extensions.Annotated[
        typing.Optional[Attachment], FieldMetadata(alias="sourceAttachment")
    ] = pydantic.Field(default=None)
    """
    The source on which this consent statement is based. The source might be a scanned original paper form, or a reference to a consent that links back to such a source, a reference to a document repository (e.g. XDS) that stores the original consent document.
    """

    source_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="sourceReference")
    ] = pydantic.Field(default=None)
    """
    The source on which this consent statement is based. The source might be a scanned original paper form, or a reference to a consent that links back to such a source, a reference to a document repository (e.g. XDS) that stores the original consent document.
    """

    policy: typing.Optional[typing.List[ConsentPolicy]] = pydantic.Field(default=None)
    """
    The references to the policies that are included in this consent scope. Policies may be organizational, but are often defined jurisdictionally, or in law.
    """

    policy_rule: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="policyRule")
    ] = pydantic.Field(default=None)
    """
    A reference to the specific base computable regulation or policy.
    """

    verification: typing.Optional[typing.List[ConsentVerification]] = pydantic.Field(
        default=None
    )
    """
    Whether a treatment instruction (e.g. artificial respiration yes or no) was verified with the patient, his/her family or another authorized person.
    """

    provision: typing.Optional[ConsentProvision] = pydantic.Field(default=None)
    """
    An exception to the base policy of this consent. An exception can be an addition or removal of access permissions.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
