# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .date_time import DateTime
from .condition_stage import ConditionStage
from .condition_evidence import ConditionEvidence
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Condition(BaseResource):
    """
    A clinical condition, problem, diagnosis, or other event, situation, issue, or clinical concept that has risen to a level of concern.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Condition"], FieldMetadata(alias="resourceType")
    ] = "Condition"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Business identifiers assigned to this condition by the performer or other systems which remain constant as the resource is updated and propagates from server to server.
    """

    clinical_status: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="clinicalStatus")
    ] = pydantic.Field(default=None)
    """
    The clinical status of the condition.
    """

    verification_status: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="verificationStatus")
    ] = pydantic.Field(default=None)
    """
    The verification status to support the clinical status of the condition.
    """

    category: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A category assigned to the condition.
    """

    severity: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    A subjective assessment of the severity of the condition as evaluated by the clinician.
    """

    code: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Identification of the condition, problem or diagnosis.
    """

    body_site: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="bodySite")
    ] = pydantic.Field(default=None)
    """
    The anatomical location where this condition manifests itself.
    """

    subject: Reference = pydantic.Field()
    """
    Indicates the patient or group who the condition record is associated with.
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The Encounter during which this Condition was created or to which the creation of this record is tightly associated.
    """

    onset_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="onsetDateTime")
    ] = pydantic.Field(default=None)
    """
    Estimated or actual date or date-time the condition began, in the opinion of the clinician.
    """

    onset_age: typing_extensions.Annotated[
        typing.Optional[Age], FieldMetadata(alias="onsetAge")
    ] = pydantic.Field(default=None)
    """
    Estimated or actual date or date-time the condition began, in the opinion of the clinician.
    """

    onset_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="onsetPeriod")
    ] = pydantic.Field(default=None)
    """
    Estimated or actual date or date-time the condition began, in the opinion of the clinician.
    """

    onset_range: typing_extensions.Annotated[
        typing.Optional[Range], FieldMetadata(alias="onsetRange")
    ] = pydantic.Field(default=None)
    """
    Estimated or actual date or date-time the condition began, in the opinion of the clinician.
    """

    onset_string: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="onsetString")
    ] = pydantic.Field(default=None)
    """
    Estimated or actual date or date-time the condition began, in the opinion of the clinician.
    """

    abatement_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="abatementDateTime")
    ] = pydantic.Field(default=None)
    """
    The date or estimated date that the condition resolved or went into remission. This is called "abatement" because of the many overloaded connotations associated with "remission" or "resolution" - Conditions are never really resolved, but they can abate.
    """

    abatement_age: typing_extensions.Annotated[
        typing.Optional[Age], FieldMetadata(alias="abatementAge")
    ] = pydantic.Field(default=None)
    """
    The date or estimated date that the condition resolved or went into remission. This is called "abatement" because of the many overloaded connotations associated with "remission" or "resolution" - Conditions are never really resolved, but they can abate.
    """

    abatement_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="abatementPeriod")
    ] = pydantic.Field(default=None)
    """
    The date or estimated date that the condition resolved or went into remission. This is called "abatement" because of the many overloaded connotations associated with "remission" or "resolution" - Conditions are never really resolved, but they can abate.
    """

    abatement_range: typing_extensions.Annotated[
        typing.Optional[Range], FieldMetadata(alias="abatementRange")
    ] = pydantic.Field(default=None)
    """
    The date or estimated date that the condition resolved or went into remission. This is called "abatement" because of the many overloaded connotations associated with "remission" or "resolution" - Conditions are never really resolved, but they can abate.
    """

    abatement_string: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="abatementString")
    ] = pydantic.Field(default=None)
    """
    The date or estimated date that the condition resolved or went into remission. This is called "abatement" because of the many overloaded connotations associated with "remission" or "resolution" - Conditions are never really resolved, but they can abate.
    """

    recorded_date: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="recordedDate")
    ] = pydantic.Field(default=None)
    """
    The recordedDate represents when this particular Condition record was created in the system, which is often a system-generated date.
    """

    recorder: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Individual who recorded the record and takes responsibility for its content.
    """

    asserter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Individual who is making the condition statement.
    """

    stage: typing.Optional[typing.List[ConditionStage]] = pydantic.Field(default=None)
    """
    Clinical stage or grade of a condition. May include formal severity assessments.
    """

    evidence: typing.Optional[typing.List[ConditionEvidence]] = pydantic.Field(
        default=None
    )
    """
    Supporting evidence / manifestations that are the basis of the Condition's verification status, such as evidence that confirmed or refuted the condition.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Additional information about the Condition. This is a general notes/comments entry for description of the Condition, its diagnosis and prognosis.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
