# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
from .composition_section import CompositionSection
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .composition_status import CompositionStatus
from .date_time import DateTime
from .code import Code
from .composition_attester import CompositionAttester
from .composition_relates_to import CompositionRelatesTo
from .composition_event import CompositionEvent
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Composition(BaseResource):
    """
    A set of healthcare-related information that is assembled together into a single logical package that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. A Composition defines the structure and narrative content necessary for a document. However, a Composition alone does not constitute a document. Rather, the Composition must be the first entry in a Bundle where Bundle.type=document, and any other resources referenced from Composition must be included as subsequent entries in the Bundle (for example Patient, Practitioner, Encounter, etc.).
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Composition"], FieldMetadata(alias="resourceType")
    ] = "Composition"
    identifier: typing.Optional[Identifier] = pydantic.Field(default=None)
    """
    A version-independent identifier for the Composition. This identifier stays constant as the composition is changed over time.
    """

    status: typing.Optional[CompositionStatus] = pydantic.Field(default=None)
    """
    The workflow/clinical status of this composition. The status is a marker for the clinical standing of the document.
    """

    type: CodeableConcept = pydantic.Field()
    """
    Specifies the particular kind of composition (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the composition.
    """

    category: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A categorization for the type of the composition - helps for indexing and searching. This may be implied by or derived from the code specified in the Composition Type.
    """

    subject: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Who or what the composition is about. The composition can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of livestock, or a set of patients that share a common exposure).
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Describes the clinical encounter or type of care this documentation is associated with.
    """

    date: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The composition editing time, when the composition was last logically changed by the author.
    """

    author: typing.List[Reference] = pydantic.Field()
    """
    Identifies who is responsible for the information in the composition, not necessarily who typed it in.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    Official human-readable label for the composition.
    """

    confidentiality: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The code specifying the level of confidentiality of the Composition.
    """

    attester: typing.Optional[typing.List[CompositionAttester]] = pydantic.Field(
        default=None
    )
    """
    A participant who has attested to the accuracy of the composition/document.
    """

    custodian: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Identifies the organization or group who is responsible for ongoing maintenance of and access to the composition/document information.
    """

    relates_to: typing_extensions.Annotated[
        typing.Optional[typing.List[CompositionRelatesTo]],
        FieldMetadata(alias="relatesTo"),
    ] = pydantic.Field(default=None)
    """
    Relationships that this composition has with other compositions or documents that already exist.
    """

    event: typing.Optional[typing.List[CompositionEvent]] = pydantic.Field(default=None)
    """
    The clinical service, such as a colonoscopy or an appendectomy, being documented.
    """

    section: typing.Optional[typing.List[CompositionSection]] = pydantic.Field(
        default=None
    )
    """
    The root of the sections that make up the composition.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
