# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .code import Code
from .communication_request_payload import CommunicationRequestPayload
from .date_time import DateTime
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CommunicationRequest(BaseResource):
    """
    A request to convey information; e.g. the CDS system proposes that an alert be sent to a responsible provider, the CDS system proposes that the public health agency be notified about a reportable condition.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["CommunicationRequest"], FieldMetadata(alias="resourceType")
    ] = "CommunicationRequest"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Business identifiers assigned to this communication request by the performer or other systems which remain constant as the resource is updated and propagates from server to server.
    """

    based_on: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="basedOn")
    ] = pydantic.Field(default=None)
    """
    A plan or proposal that is fulfilled in whole or in part by this request.
    """

    replaces: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Completed or terminated request(s) whose function is taken by this new request.
    """

    group_identifier: typing_extensions.Annotated[
        typing.Optional[Identifier], FieldMetadata(alias="groupIdentifier")
    ] = pydantic.Field(default=None)
    """
    A shared identifier common to all requests that were authorized more or less simultaneously by a single author, representing the identifier of the requisition, prescription or similar form.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The status of the proposal or order.
    """

    status_reason: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="statusReason")
    ] = pydantic.Field(default=None)
    """
    Captures the reason for the current state of the CommunicationRequest.
    """

    category: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    The type of message to be sent such as alert, notification, reminder, instruction, etc.
    """

    priority: typing.Optional[Code] = pydantic.Field(default=None)
    """
    Characterizes how quickly the proposed act must be initiated. Includes concepts such as stat, urgent, routine.
    """

    do_not_perform: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="doNotPerform")
    ] = pydantic.Field(default=None)
    """
    If true indicates that the CommunicationRequest is asking for the specified action to _not_ occur.
    """

    medium: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    A channel that was used for this communication (e.g. email, fax).
    """

    subject: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The patient or group that is the focus of this communication request.
    """

    about: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Other resources that pertain to this communication request and to which this communication request should be associated.
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The Encounter during which this CommunicationRequest was created or to which the creation of this record is tightly associated.
    """

    payload: typing.Optional[typing.List[CommunicationRequestPayload]] = pydantic.Field(
        default=None
    )
    """
    Text, attachment(s), or resource(s) to be communicated to the recipient.
    """

    occurrence_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="occurrenceDateTime")
    ] = pydantic.Field(default=None)
    """
    The time when this communication is to occur.
    """

    occurrence_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="occurrencePeriod")
    ] = pydantic.Field(default=None)
    """
    The time when this communication is to occur.
    """

    authored_on: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="authoredOn")
    ] = pydantic.Field(default=None)
    """
    For draft requests, indicates the date of initial creation. For requests with other statuses, indicates the date of activation.
    """

    requester: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The device, individual, or organization who initiated the request and has responsibility for its activation.
    """

    recipient: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The entity (e.g. person, organization, clinical information system, device, group, or care team) which is the intended target of the communication.
    """

    sender: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The entity (e.g. person, organization, clinical information system, or device) which is to be the source of the communication.
    """

    reason_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="reasonCode")
    ] = pydantic.Field(default=None)
    """
    Describes why the request is being made in coded or textual form.
    """

    reason_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="reasonReference")
    ] = pydantic.Field(default=None)
    """
    Indicates another resource whose existence justifies this request.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Comments made about the request by the requester, sender, recipient, subject or other participants.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
