# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .canonical import Canonical
from .uri import Uri
from .code import Code
from .date_time import DateTime
from .communication_payload import CommunicationPayload
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Communication(BaseResource):
    """
    An occurrence of information being transmitted; e.g. an alert that was sent to a responsible provider, a public health agency that was notified about a reportable condition.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Communication"], FieldMetadata(alias="resourceType")
    ] = "Communication"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Business identifiers assigned to this communication by the performer or other systems which remain constant as the resource is updated and propagates from server to server.
    """

    instantiates_canonical: typing_extensions.Annotated[
        typing.Optional[typing.List[Canonical]],
        FieldMetadata(alias="instantiatesCanonical"),
    ] = pydantic.Field(default=None)
    """
    The URL pointing to a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this Communication.
    """

    instantiates_uri: typing_extensions.Annotated[
        typing.Optional[typing.List[Uri]], FieldMetadata(alias="instantiatesUri")
    ] = pydantic.Field(default=None)
    """
    The URL pointing to an externally maintained protocol, guideline, orderset or other definition that is adhered to in whole or in part by this Communication.
    """

    based_on: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="basedOn")
    ] = pydantic.Field(default=None)
    """
    An order, proposal or plan fulfilled in whole or in part by this Communication.
    """

    part_of: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="partOf")
    ] = pydantic.Field(default=None)
    """
    Part of this action.
    """

    in_response_to: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="inResponseTo")
    ] = pydantic.Field(default=None)
    """
    Prior communication that this communication is in response to.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The status of the transmission.
    """

    status_reason: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="statusReason")
    ] = pydantic.Field(default=None)
    """
    Captures the reason for the current state of the Communication.
    """

    category: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    The type of message conveyed such as alert, notification, reminder, instruction, etc.
    """

    priority: typing.Optional[Code] = pydantic.Field(default=None)
    """
    Characterizes how quickly the planned or in progress communication must be addressed. Includes concepts such as stat, urgent, routine.
    """

    medium: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    A channel that was used for this communication (e.g. email, fax).
    """

    subject: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The patient or group that was the focus of this communication.
    """

    topic: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Description of the purpose/content, similar to a subject line in an email.
    """

    about: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Other resources that pertain to this communication and to which this communication should be associated.
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The Encounter during which this Communication was created or to which the creation of this record is tightly associated.
    """

    sent: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The time when this communication was sent.
    """

    received: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The time when this communication arrived at the destination.
    """

    recipient: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The entity (e.g. person, organization, clinical information system, care team or device) which was the target of the communication. If receipts need to be tracked by an individual, a separate resource instance will need to be created for each recipient. Multiple recipient communications are intended where either receipts are not tracked (e.g. a mass mail-out) or a receipt is captured in aggregate (all emails confirmed received by a particular time).
    """

    sender: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The entity (e.g. person, organization, clinical information system, or device) which was the source of the communication.
    """

    reason_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="reasonCode")
    ] = pydantic.Field(default=None)
    """
    The reason or justification for the communication.
    """

    reason_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="reasonReference")
    ] = pydantic.Field(default=None)
    """
    Indicates another resource whose existence justifies this communication.
    """

    payload: typing.Optional[typing.List[CommunicationPayload]] = pydantic.Field(
        default=None
    )
    """
    Text, attachment(s), or resource(s) that was communicated to the recipient.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Additional notes or commentary about the communication by the sender, receiver or other interested parties.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
