# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
from .code_system_concept import CodeSystemConcept
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
from .uri import Uri
import pydantic
from .code_system_status import CodeSystemStatus
from .date_time import DateTime
from .markdown import Markdown
from .canonical import Canonical
from .code_system_hierarchy_meaning import CodeSystemHierarchyMeaning
from .code_system_content import CodeSystemContent
from .unsigned_int import UnsignedInt
from .code_system_filter import CodeSystemFilter
from .code_system_property import CodeSystemProperty
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CodeSystem(BaseResource):
    """
    The CodeSystem resource is used to declare the existence of and describe a code system or code system supplement and its key properties, and optionally define a part or all of its content.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["CodeSystem"], FieldMetadata(alias="resourceType")
    ] = "CodeSystem"
    url: typing.Optional[Uri] = pydantic.Field(default=None)
    """
    An absolute URI that is used to identify this code system when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this code system is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the code system is stored on different servers. This is used in [Coding](datatypes.html#Coding).system.
    """

    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    A formal identifier that is used to identify this code system when it is represented in other formats, or referenced in a specification, model, design or an instance.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The identifier that is used to identify this version of the code system when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the code system author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. This is used in [Coding](datatypes.html#Coding).version.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A natural language name identifying the code system. This name should be usable as an identifier for the module by machine processing applications such as code generation.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    A short, descriptive, user-friendly title for the code system.
    """

    status: typing.Optional[CodeSystemStatus] = pydantic.Field(default=None)
    """
    The date (and optionally time) when the code system resource was created or revised.
    """

    experimental: typing.Optional[bool] = pydantic.Field(default=None)
    """
    A Boolean value to indicate that this code system is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.
    """

    date: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date (and optionally time) when the code system was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the code system changes.
    """

    publisher: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the organization or individual that published the code system.
    """

    contact: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    Contact details to assist a user in finding and communicating with the publisher.
    """

    description: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    A free text natural language description of the code system from a consumer's perspective.
    """

    use_context: typing_extensions.Annotated[
        typing.Optional[typing.List[UsageContext]], FieldMetadata(alias="useContext")
    ] = pydantic.Field(default=None)
    """
    The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate code system instances.
    """

    jurisdiction: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A legal or geographic region in which the code system is intended to be used.
    """

    purpose: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    Explanation of why this code system is needed and why it has been designed as it has.
    """

    copyright: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    A copyright statement relating to the code system and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the code system.
    """

    case_sensitive: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="caseSensitive")
    ] = pydantic.Field(default=None)
    """
    If code comparison is case sensitive when codes within this system are compared to each other.
    """

    value_set: typing_extensions.Annotated[
        typing.Optional[Canonical], FieldMetadata(alias="valueSet")
    ] = pydantic.Field(default=None)
    """
    Canonical reference to the value set that contains the entire code system.
    """

    hierarchy_meaning: typing_extensions.Annotated[
        typing.Optional[CodeSystemHierarchyMeaning],
        FieldMetadata(alias="hierarchyMeaning"),
    ] = pydantic.Field(default=None)
    """
    The meaning of the hierarchy of concepts as represented in this resource.
    """

    compositional: typing.Optional[bool] = pydantic.Field(default=None)
    """
    The code system defines a compositional (post-coordination) grammar.
    """

    version_needed: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="versionNeeded")
    ] = pydantic.Field(default=None)
    """
    This flag is used to signify that the code system does not commit to concept permanence across versions. If true, a version must be specified when referencing this code system.
    """

    content: typing.Optional[CodeSystemContent] = pydantic.Field(default=None)
    """
    The extent of the content of the code system (the concepts and codes it defines) are represented in this resource instance.
    """

    supplements: typing.Optional[Canonical] = pydantic.Field(default=None)
    """
    The canonical URL of the code system that this code system supplement is adding designations and properties to.
    """

    count: typing.Optional[UnsignedInt] = pydantic.Field(default=None)
    """
    The total number of concepts defined by the code system. Where the code system has a compositional grammar, the basis of this count is defined by the system steward.
    """

    filter: typing.Optional[typing.List[CodeSystemFilter]] = pydantic.Field(
        default=None
    )
    """
    A filter that can be used in a value set compose statement when selecting concepts using a filter.
    """

    property: typing.Optional[typing.List[CodeSystemProperty]] = pydantic.Field(
        default=None
    )
    """
    A property defines an additional slot through which additional information can be provided about a concept.
    """

    concept: typing.Optional[typing.List[CodeSystemConcept]] = pydantic.Field(
        default=None
    )
    """
    Concepts that are in the code system. The concept definitions are inherently hierarchical, but the definitions must be consulted to determine what the meanings of the hierarchical relationships are.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
