# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .code import Code
from .date_time import DateTime
from .clinical_impression_investigation import ClinicalImpressionInvestigation
from .uri import Uri
from .clinical_impression_finding import ClinicalImpressionFinding
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ClinicalImpression(BaseResource):
    """
    A record of a clinical assessment performed to determine what problem(s) may affect the patient and before planning the treatments or management strategies that are best to manage a patient's condition. Assessments are often 1:1 with a clinical consultation / encounter, but this varies greatly depending on the clinical workflow. This resource is called "ClinicalImpression" rather than "ClinicalAssessment" to avoid confusion with the recording of assessment tools such as Apgar score.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["ClinicalImpression"], FieldMetadata(alias="resourceType")
    ] = "ClinicalImpression"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Business identifiers assigned to this clinical impression by the performer or other systems which remain constant as the resource is updated and propagates from server to server.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    Identifies the workflow status of the assessment.
    """

    status_reason: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="statusReason")
    ] = pydantic.Field(default=None)
    """
    Captures the reason for the current state of the ClinicalImpression.
    """

    code: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Categorizes the type of clinical assessment performed.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    A summary of the context and/or cause of the assessment - why / where it was performed, and what patient events/status prompted it.
    """

    subject: Reference = pydantic.Field()
    """
    The patient or group of individuals assessed as part of this record.
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The Encounter during which this ClinicalImpression was created or to which the creation of this record is tightly associated.
    """

    effective_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="effectiveDateTime")
    ] = pydantic.Field(default=None)
    """
    The point in time or period over which the subject was assessed.
    """

    effective_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="effectivePeriod")
    ] = pydantic.Field(default=None)
    """
    The point in time or period over which the subject was assessed.
    """

    date: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    Indicates when the documentation of the assessment was complete.
    """

    assessor: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The clinician performing the assessment.
    """

    previous: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    A reference to the last assessment that was conducted on this patient. Assessments are often/usually ongoing in nature; a care provider (practitioner or team) will make new assessments on an ongoing basis as new data arises or the patient's conditions changes.
    """

    problem: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    A list of the relevant problems/conditions for a patient.
    """

    investigation: typing.Optional[typing.List[ClinicalImpressionInvestigation]] = (
        pydantic.Field(default=None)
    )
    """
    One or more sets of investigations (signs, symptoms, etc.). The actual grouping of investigations varies greatly depending on the type and context of the assessment. These investigations may include data generated during the assessment process, or data previously generated and recorded that is pertinent to the outcomes.
    """

    protocol: typing.Optional[typing.List[Uri]] = pydantic.Field(default=None)
    """
    Reference to a specific published clinical protocol that was followed during this assessment, and/or that provides evidence in support of the diagnosis.
    """

    summary: typing.Optional[str] = pydantic.Field(default=None)
    """
    A text summary of the investigations and the diagnosis.
    """

    finding: typing.Optional[typing.List[ClinicalImpressionFinding]] = pydantic.Field(
        default=None
    )
    """
    Specific findings or diagnoses that were considered likely or relevant to ongoing treatment.
    """

    prognosis_codeable_concept: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="prognosisCodeableConcept"),
    ] = pydantic.Field(default=None)
    """
    Estimate of likely outcome.
    """

    prognosis_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="prognosisReference"),
    ] = pydantic.Field(default=None)
    """
    RiskAssessment expressing likely outcome.
    """

    supporting_info: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="supportingInfo")
    ] = pydantic.Field(default=None)
    """
    Information supporting the clinical impression.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Commentary about the impression, typically recorded after the impression itself was made, though supplemental notes by the original author could also appear.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
