# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .positive_int import PositiveInt
from .decimal import Decimal
from .claim_response_adjudication import ClaimResponseAdjudication
from .claim_response_detail_1 import ClaimResponseDetail1
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ClaimResponseAddItem(UniversalBaseModel):
    """
    This resource provides the adjudication details from the processing of a Claim resource.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    item_sequence: typing_extensions.Annotated[
        typing.Optional[typing.List[PositiveInt]], FieldMetadata(alias="itemSequence")
    ] = pydantic.Field(default=None)
    """
    Claim items which this service line is intended to replace.
    """

    detail_sequence: typing_extensions.Annotated[
        typing.Optional[typing.List[PositiveInt]], FieldMetadata(alias="detailSequence")
    ] = pydantic.Field(default=None)
    """
    The sequence number of the details within the claim item which this line is intended to replace.
    """

    subdetail_sequence: typing_extensions.Annotated[
        typing.Optional[typing.List[PositiveInt]],
        FieldMetadata(alias="subdetailSequence"),
    ] = pydantic.Field(default=None)
    """
    The sequence number of the sub-details within the details within the claim item which this line is intended to replace.
    """

    provider: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The providers who are authorized for the services rendered to the patient.
    """

    product_or_service: typing_extensions.Annotated[
        CodeableConcept, FieldMetadata(alias="productOrService")
    ] = pydantic.Field()
    """
    When the value is a group code then this item collects a set of related claim details, otherwise this contains the product, service, drug or other billing code for the item.
    """

    modifier: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    Item typification or modifiers codes to convey additional context for the product or service.
    """

    program_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="programCode"),
    ] = pydantic.Field(default=None)
    """
    Identifies the program under which this may be recovered.
    """

    serviced_date: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="servicedDate")
    ] = pydantic.Field(default=None)
    """
    The date or dates when the service or product was supplied, performed or completed.
    """

    serviced_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="servicedPeriod")
    ] = pydantic.Field(default=None)
    """
    The date or dates when the service or product was supplied, performed or completed.
    """

    location_codeable_concept: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="locationCodeableConcept")
    ] = pydantic.Field(default=None)
    """
    Where the product or service was provided.
    """

    location_address: typing_extensions.Annotated[
        typing.Optional[Address], FieldMetadata(alias="locationAddress")
    ] = pydantic.Field(default=None)
    """
    Where the product or service was provided.
    """

    location_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="locationReference")
    ] = pydantic.Field(default=None)
    """
    Where the product or service was provided.
    """

    quantity: typing.Optional[Quantity] = pydantic.Field(default=None)
    """
    The number of repetitions of a service or product.
    """

    unit_price: typing_extensions.Annotated[
        typing.Optional[Money], FieldMetadata(alias="unitPrice")
    ] = pydantic.Field(default=None)
    """
    If the item is not a group then this is the fee for the product or service, otherwise this is the total of the fees for the details of the group.
    """

    factor: typing.Optional[Decimal] = pydantic.Field(default=None)
    """
    A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.
    """

    net: typing.Optional[Money] = pydantic.Field(default=None)
    """
    The quantity times the unit price for an additional service or product or charge.
    """

    body_site: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="bodySite")
    ] = pydantic.Field(default=None)
    """
    Physical service site on the patient (limb, tooth, etc.).
    """

    sub_site: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="subSite")
    ] = pydantic.Field(default=None)
    """
    A region or surface of the bodySite, e.g. limb region or tooth surface(s).
    """

    note_number: typing_extensions.Annotated[
        typing.Optional[typing.List[PositiveInt]], FieldMetadata(alias="noteNumber")
    ] = pydantic.Field(default=None)
    """
    The numbers associated with notes below which apply to the adjudication of this item.
    """

    adjudication: typing.List[ClaimResponseAdjudication] = pydantic.Field()
    """
    The adjudication results.
    """

    detail: typing.Optional[typing.List[ClaimResponseDetail1]] = pydantic.Field(
        default=None
    )
    """
    The second-tier service adjudications for payor added services.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
