# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .code import Code
from .date_time import DateTime
from .claim_response_item import ClaimResponseItem
from .claim_response_add_item import ClaimResponseAddItem
from .claim_response_adjudication import ClaimResponseAdjudication
from .claim_response_total import ClaimResponseTotal
from .claim_response_payment import ClaimResponsePayment
from .claim_response_process_note import ClaimResponseProcessNote
from .claim_response_insurance import ClaimResponseInsurance
from .claim_response_error import ClaimResponseError
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ClaimResponse(BaseResource):
    """
    This resource provides the adjudication details from the processing of a Claim resource.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["ClaimResponse"], FieldMetadata(alias="resourceType")
    ] = "ClaimResponse"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    A unique identifier assigned to this claim response.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The status of the resource instance.
    """

    type: CodeableConcept = pydantic.Field()
    """
    A finer grained suite of claim type codes which may convey additional information such as Inpatient vs Outpatient and/or a specialty service.
    """

    sub_type: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="subType")
    ] = pydantic.Field(default=None)
    """
    A finer grained suite of claim type codes which may convey additional information such as Inpatient vs Outpatient and/or a specialty service.
    """

    use: typing.Optional[Code] = pydantic.Field(default=None)
    """
    A code to indicate whether the nature of the request is: to request adjudication of products and services previously rendered; or requesting authorization and adjudication for provision in the future; or requesting the non-binding adjudication of the listed products and services which could be provided in the future.
    """

    patient: Reference = pydantic.Field()
    """
    The party to whom the professional services and/or products have been supplied or are being considered and for whom actual for facast reimbursement is sought.
    """

    created: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date this resource was created.
    """

    insurer: Reference = pydantic.Field()
    """
    The party responsible for authorization, adjudication and reimbursement.
    """

    requestor: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The provider which is responsible for the claim, predetermination or preauthorization.
    """

    request: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Original request resource reference.
    """

    outcome: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The outcome of the claim, predetermination, or preauthorization processing.
    """

    disposition: typing.Optional[str] = pydantic.Field(default=None)
    """
    A human readable description of the status of the adjudication.
    """

    pre_auth_ref: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="preAuthRef")
    ] = pydantic.Field(default=None)
    """
    Reference from the Insurer which is used in later communications which refers to this adjudication.
    """

    pre_auth_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="preAuthPeriod")
    ] = pydantic.Field(default=None)
    """
    The time frame during which this authorization is effective.
    """

    payee_type: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="payeeType")
    ] = pydantic.Field(default=None)
    """
    Type of Party to be reimbursed: subscriber, provider, other.
    """

    item: typing.Optional[typing.List[ClaimResponseItem]] = pydantic.Field(default=None)
    """
    A claim line. Either a simple (a product or service) or a 'group' of details which can also be a simple items or groups of sub-details.
    """

    add_item: typing_extensions.Annotated[
        typing.Optional[typing.List[ClaimResponseAddItem]],
        FieldMetadata(alias="addItem"),
    ] = pydantic.Field(default=None)
    """
    The first-tier service adjudications for payor added product or service lines.
    """

    adjudication: typing.Optional[typing.List[ClaimResponseAdjudication]] = (
        pydantic.Field(default=None)
    )
    """
    The adjudication results which are presented at the header level rather than at the line-item or add-item levels.
    """

    total: typing.Optional[typing.List[ClaimResponseTotal]] = pydantic.Field(
        default=None
    )
    """
    Categorized monetary totals for the adjudication.
    """

    payment: typing.Optional[ClaimResponsePayment] = pydantic.Field(default=None)
    """
    Payment details for the adjudication of the claim.
    """

    funds_reserve: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="fundsReserve")
    ] = pydantic.Field(default=None)
    """
    A code, used only on a response to a preauthorization, to indicate whether the benefits payable have been reserved and for whom.
    """

    form_code: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="formCode")
    ] = pydantic.Field(default=None)
    """
    A code for the form to be used for printing the content.
    """

    form: typing.Optional[Attachment] = pydantic.Field(default=None)
    """
    The actual form, by reference or inclusion, for printing the content or an EOB.
    """

    process_note: typing_extensions.Annotated[
        typing.Optional[typing.List[ClaimResponseProcessNote]],
        FieldMetadata(alias="processNote"),
    ] = pydantic.Field(default=None)
    """
    A note that describes or explains adjudication results in a human readable form.
    """

    communication_request: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="communicationRequest"),
    ] = pydantic.Field(default=None)
    """
    Request for additional supporting or authorizing information.
    """

    insurance: typing.Optional[typing.List[ClaimResponseInsurance]] = pydantic.Field(
        default=None
    )
    """
    Financial instruments for reimbursement for the health care products and services specified on the claim.
    """

    error: typing.Optional[typing.List[ClaimResponseError]] = pydantic.Field(
        default=None
    )
    """
    Errors encountered during the processing of the adjudication.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
