# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .code import Code
from .claim_use import ClaimUse
from .date_time import DateTime
from .claim_related import ClaimRelated
from .claim_payee import ClaimPayee
from .claim_care_team import ClaimCareTeam
from .claim_supporting_info import ClaimSupportingInfo
from .claim_diagnosis import ClaimDiagnosis
from .claim_procedure import ClaimProcedure
from .claim_insurance import ClaimInsurance
from .claim_accident import ClaimAccident
from .claim_item import ClaimItem
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Claim(BaseResource):
    """
    A provider issued list of professional services and products which have been provided, or are to be provided, to a patient which is sent to an insurer for reimbursement.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Claim"], FieldMetadata(alias="resourceType")
    ] = "Claim"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    A unique identifier assigned to this claim.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The status of the resource instance.
    """

    type: CodeableConcept = pydantic.Field()
    """
    The category of claim, e.g. oral, pharmacy, vision, institutional, professional.
    """

    sub_type: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="subType")
    ] = pydantic.Field(default=None)
    """
    A finer grained suite of claim type codes which may convey additional information such as Inpatient vs Outpatient and/or a specialty service.
    """

    use: typing.Optional[ClaimUse] = pydantic.Field(default=None)
    """
    A code to indicate whether the nature of the request is: to request adjudication of products and services previously rendered; or requesting authorization and adjudication for provision in the future; or requesting the non-binding adjudication of the listed products and services which could be provided in the future.
    """

    patient: Reference = pydantic.Field()
    """
    The party to whom the professional services and/or products have been supplied or are being considered and for whom actual or forecast reimbursement is sought.
    """

    billable_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="billablePeriod")
    ] = pydantic.Field(default=None)
    """
    The period for which charges are being submitted.
    """

    created: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date this resource was created.
    """

    enterer: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Individual who created the claim, predetermination or preauthorization.
    """

    insurer: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The Insurer who is target of the request.
    """

    provider: Reference = pydantic.Field()
    """
    The provider which is responsible for the claim, predetermination or preauthorization.
    """

    priority: CodeableConcept = pydantic.Field()
    """
    The provider-required urgency of processing the request. Typical values include: stat, routine deferred.
    """

    funds_reserve: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="fundsReserve")
    ] = pydantic.Field(default=None)
    """
    A code to indicate whether and for whom funds are to be reserved for future claims.
    """

    related: typing.Optional[typing.List[ClaimRelated]] = pydantic.Field(default=None)
    """
    Other claims which are related to this claim such as prior submissions or claims for related services or for the same event.
    """

    prescription: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Prescription to support the dispensing of pharmacy, device or vision products.
    """

    original_prescription: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="originalPrescription")
    ] = pydantic.Field(default=None)
    """
    Original prescription which has been superseded by this prescription to support the dispensing of pharmacy services, medications or products.
    """

    payee: typing.Optional[ClaimPayee] = pydantic.Field(default=None)
    """
    The party to be reimbursed for cost of the products and services according to the terms of the policy.
    """

    referral: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    A reference to a referral resource.
    """

    facility: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Facility where the services were provided.
    """

    care_team: typing_extensions.Annotated[
        typing.Optional[typing.List[ClaimCareTeam]], FieldMetadata(alias="careTeam")
    ] = pydantic.Field(default=None)
    """
    The members of the team who provided the products and services.
    """

    supporting_info: typing_extensions.Annotated[
        typing.Optional[typing.List[ClaimSupportingInfo]],
        FieldMetadata(alias="supportingInfo"),
    ] = pydantic.Field(default=None)
    """
    Additional information codes regarding exceptions, special considerations, the condition, situation, prior or concurrent issues.
    """

    diagnosis: typing.Optional[typing.List[ClaimDiagnosis]] = pydantic.Field(
        default=None
    )
    """
    Information about diagnoses relevant to the claim items.
    """

    procedure: typing.Optional[typing.List[ClaimProcedure]] = pydantic.Field(
        default=None
    )
    """
    Procedures performed on the patient relevant to the billing items with the claim.
    """

    insurance: typing.List[ClaimInsurance] = pydantic.Field()
    """
    Financial instruments for reimbursement for the health care products and services specified on the claim.
    """

    accident: typing.Optional[ClaimAccident] = pydantic.Field(default=None)
    """
    Details of an accident which resulted in injuries which required the products and services listed in the claim.
    """

    item: typing.Optional[typing.List[ClaimItem]] = pydantic.Field(default=None)
    """
    A claim line. Either a simple product or service or a 'group' of details which can each be a simple items or groups of sub-details.
    """

    total: typing.Optional[Money] = pydantic.Field(default=None)
    """
    The total value of the all the items in the claim.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
