# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .uri import Uri
from .canonical import Canonical
from .charge_item_status import ChargeItemStatus
from .charge_item_performer import ChargeItemPerformer
from .decimal import Decimal
from .date_time import DateTime
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ChargeItem(BaseResource):
    """
    The resource ChargeItem describes the provision of healthcare provider products for a certain patient, therefore referring not only to the product, but containing in addition details of the provision, like date, time, amounts and participating organizations and persons. Main Usage of the ChargeItem is to enable the billing process and internal cost allocation.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["ChargeItem"], FieldMetadata(alias="resourceType")
    ] = "ChargeItem"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Identifiers assigned to this event performer or other systems.
    """

    definition_uri: typing_extensions.Annotated[
        typing.Optional[typing.List[Uri]], FieldMetadata(alias="definitionUri")
    ] = pydantic.Field(default=None)
    """
    References the (external) source of pricing information, rules of application for the code this ChargeItem uses.
    """

    definition_canonical: typing_extensions.Annotated[
        typing.Optional[typing.List[Canonical]],
        FieldMetadata(alias="definitionCanonical"),
    ] = pydantic.Field(default=None)
    """
    References the source of pricing information, rules of application for the code this ChargeItem uses.
    """

    status: typing.Optional[ChargeItemStatus] = pydantic.Field(default=None)
    """
    The current state of the ChargeItem.
    """

    part_of: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="partOf")
    ] = pydantic.Field(default=None)
    """
    ChargeItems can be grouped to larger ChargeItems covering the whole set.
    """

    code: CodeableConcept = pydantic.Field()
    """
    A code that identifies the charge, like a billing code.
    """

    subject: Reference = pydantic.Field()
    """
    The individual or set of individuals the action is being or was performed on.
    """

    context: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The encounter or episode of care that establishes the context for this event.
    """

    occurrence_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="occurrenceDateTime")
    ] = pydantic.Field(default=None)
    """
    Date/time(s) or duration when the charged service was applied.
    """

    occurrence_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="occurrencePeriod")
    ] = pydantic.Field(default=None)
    """
    Date/time(s) or duration when the charged service was applied.
    """

    occurrence_timing: typing_extensions.Annotated[
        typing.Optional[Timing], FieldMetadata(alias="occurrenceTiming")
    ] = pydantic.Field(default=None)
    """
    Date/time(s) or duration when the charged service was applied.
    """

    performer: typing.Optional[typing.List[ChargeItemPerformer]] = pydantic.Field(
        default=None
    )
    """
    Indicates who or what performed or participated in the charged service.
    """

    performing_organization: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="performingOrganization")
    ] = pydantic.Field(default=None)
    """
    The organization requesting the service.
    """

    requesting_organization: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="requestingOrganization")
    ] = pydantic.Field(default=None)
    """
    The organization performing the service.
    """

    cost_center: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="costCenter")
    ] = pydantic.Field(default=None)
    """
    The financial cost center permits the tracking of charge attribution.
    """

    quantity: typing.Optional[Quantity] = pydantic.Field(default=None)
    """
    Quantity of which the charge item has been serviced.
    """

    bodysite: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    The anatomical location where the related service has been applied.
    """

    factor_override: typing_extensions.Annotated[
        typing.Optional[Decimal], FieldMetadata(alias="factorOverride")
    ] = pydantic.Field(default=None)
    """
    Factor overriding the factor determined by the rules associated with the code.
    """

    price_override: typing_extensions.Annotated[
        typing.Optional[Money], FieldMetadata(alias="priceOverride")
    ] = pydantic.Field(default=None)
    """
    Total price of the charge overriding the list price associated with the code.
    """

    override_reason: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="overrideReason")
    ] = pydantic.Field(default=None)
    """
    If the list price or the rule-based factor associated with the code is overridden, this attribute can capture a text to indicate the reason for this action.
    """

    enterer: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The device, practitioner, etc. who entered the charge item.
    """

    entered_date: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="enteredDate")
    ] = pydantic.Field(default=None)
    """
    Date the charge item was entered.
    """

    reason: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    Describes why the event occurred in coded or textual form.
    """

    service: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Indicated the rendered service that caused this charge.
    """

    product_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="productReference")
    ] = pydantic.Field(default=None)
    """
    Identifies the device, food, drug or other product being charged either by type code or reference to an instance.
    """

    product_codeable_concept: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="productCodeableConcept")
    ] = pydantic.Field(default=None)
    """
    Identifies the device, food, drug or other product being charged either by type code or reference to an instance.
    """

    account: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Account into which this ChargeItems belongs.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Comments made about the event by the performer, subject or other participants.
    """

    supporting_information: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="supportingInformation"),
    ] = pydantic.Field(default=None)
    """
    Further information supporting this charge.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
