# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .catalog_entry_status import CatalogEntryStatus
from .date_time import DateTime
from .catalog_entry_related_entry import CatalogEntryRelatedEntry
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CatalogEntry(BaseResource):
    """
    Catalog entries are wrappers that contextualize items included in a catalog.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["CatalogEntry"], FieldMetadata(alias="resourceType")
    ] = "CatalogEntry"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Used in supporting different identifiers for the same product, e.g. manufacturer code and retailer code.
    """

    type: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The type of item - medication, device, service, protocol or other.
    """

    orderable: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the entry represents an orderable item.
    """

    referenced_item: typing_extensions.Annotated[
        Reference, FieldMetadata(alias="referencedItem")
    ] = pydantic.Field()
    """
    The item in a catalog or definition.
    """

    additional_identifier: typing_extensions.Annotated[
        typing.Optional[typing.List[Identifier]],
        FieldMetadata(alias="additionalIdentifier"),
    ] = pydantic.Field(default=None)
    """
    Used in supporting related concepts, e.g. NDC to RxNorm.
    """

    classification: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    Classes of devices, or ATC for medication.
    """

    status: typing.Optional[CatalogEntryStatus] = pydantic.Field(default=None)
    """
    Used to support catalog exchange even for unsupported products, e.g. getting list of medications even if not prescribable.
    """

    validity_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="validityPeriod")
    ] = pydantic.Field(default=None)
    """
    The time period in which this catalog entry is expected to be active.
    """

    valid_to: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="validTo")
    ] = pydantic.Field(default=None)
    """
    The date until which this catalog entry is expected to be active.
    """

    last_updated: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="lastUpdated")
    ] = pydantic.Field(default=None)
    """
    Typically date of issue is different from the beginning of the validity. This can be used to see when an item was last updated.
    """

    additional_characteristic: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="additionalCharacteristic"),
    ] = pydantic.Field(default=None)
    """
    Used for examplefor Out of Formulary, or any specifics.
    """

    additional_classification: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="additionalClassification"),
    ] = pydantic.Field(default=None)
    """
    User for example for ATC classification, or.
    """

    related_entry: typing_extensions.Annotated[
        typing.Optional[typing.List[CatalogEntryRelatedEntry]],
        FieldMetadata(alias="relatedEntry"),
    ] = pydantic.Field(default=None)
    """
    Used for example, to point to a substance, or to a device used to administer a medication.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
