# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .care_team_status import CareTeamStatus
from .care_team_participant import CareTeamParticipant
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CareTeam(BaseResource):
    """
    The Care Team includes all the people and organizations who plan to participate in the coordination and delivery of care for a patient.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["CareTeam"], FieldMetadata(alias="resourceType")
    ] = "CareTeam"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Business identifiers assigned to this care team by the performer or other systems which remain constant as the resource is updated and propagates from server to server.
    """

    status: typing.Optional[CareTeamStatus] = pydantic.Field(default=None)
    """
    Indicates the current state of the care team.
    """

    category: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    Identifies what kind of team. This is to support differentiation between multiple co-existing teams, such as care plan team, episode of care team, longitudinal care team.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A label for human use intended to distinguish like teams. E.g. the "red" vs. "green" trauma teams.
    """

    subject: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Identifies the patient or group whose intended care is handled by the team.
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The Encounter during which this CareTeam was created or to which the creation of this record is tightly associated.
    """

    period: typing.Optional[Period] = pydantic.Field(default=None)
    """
    Indicates when the team did (or is intended to) come into effect and end.
    """

    participant: typing.Optional[typing.List[CareTeamParticipant]] = pydantic.Field(
        default=None
    )
    """
    Identifies all people and organizations who are expected to be involved in the care team.
    """

    reason_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="reasonCode")
    ] = pydantic.Field(default=None)
    """
    Describes why the care team exists.
    """

    reason_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="reasonReference")
    ] = pydantic.Field(default=None)
    """
    Condition(s) that this care team addresses.
    """

    managing_organization: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="managingOrganization"),
    ] = pydantic.Field(default=None)
    """
    The organization responsible for the care team.
    """

    telecom: typing.Optional[typing.List[ContactPoint]] = pydantic.Field(default=None)
    """
    A central contact detail for the care team (that applies to all members).
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Comments made about the CareTeam.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
